/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.captcha;

import com.xiaoleilu.hutool.captcha.ICaptcha;
import com.xiaoleilu.hutool.codec.Base64;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.util.ImageUtil;
import com.xiaoleilu.hutool.util.RandomUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractCaptcha
implements ICaptcha {
    private static final long serialVersionUID = 3180820918087507254L;
    protected int width = 100;
    protected int height = 37;
    protected int codeCount = 4;
    protected int interfereCount = 15;
    protected Font font;
    protected String code;
    protected BufferedImage image;

    public AbstractCaptcha(int width, int height, int codeCount, int interfereCount) {
        this.width = width;
        this.height = height;
        this.codeCount = codeCount;
        this.interfereCount = interfereCount;
        this.font = new Font("Courier", 0, this.height - 2);
    }

    @Override
    public void createCode() {
        this.generateCode();
        this.createImage(this.code);
    }

    protected void generateCode() {
        this.code = RandomUtil.randomString(this.codeCount);
    }

    protected abstract void createImage(String var1);

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public boolean verify(String userInputCode) {
        if (StrUtil.isNotBlank(userInputCode)) {
            return StrUtil.equalsIgnoreCase(this.getCode(), userInputCode);
        }
        return false;
    }

    public void write(String path) throws IORuntimeException {
        this.write(FileUtil.touch(path));
    }

    public void write(File file) throws IORuntimeException {
        try (BufferedOutputStream out = FileUtil.getOutputStream(file);){
            this.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public void write(OutputStream out) {
        ImageUtil.write((Image)this.getImage(), "png", out);
    }

    public BufferedImage getImage() {
        if (null == this.image) {
            this.createCode();
        }
        return this.image;
    }

    public String getImageBase64() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        return Base64.encode(byteArrayOutputStream.toByteArray());
    }

    public void setFont(Font font) {
        this.font = font;
    }
}

