/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert.impl;

import com.xiaoleilu.hutool.convert.AbstractConverter;
import com.xiaoleilu.hutool.convert.ConverterRegistry;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.TypeUtil;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;

public class ReferenceConverter
extends AbstractConverter<Reference> {
    private Class<? extends Reference> targetType;

    public ReferenceConverter(Class<? extends Reference> targetType) {
        this.targetType = targetType;
    }

    @Override
    protected Reference<?> convertInternal(Object value) {
        Object targetValue = null;
        Type paramType = TypeUtil.getTypeArgument(this.targetType);
        if (null != paramType) {
            targetValue = ConverterRegistry.getInstance().convert(paramType, value);
        }
        if (null == targetValue) {
            targetValue = value;
        }
        if (this.targetType == WeakReference.class) {
            return new WeakReference<Object>(targetValue);
        }
        if (this.targetType == SoftReference.class) {
            return new SoftReference<Object>(targetValue);
        }
        throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport Reference type: {}", this.targetType.getName()));
    }
}

