/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.crypto;

import com.xiaoleilu.hutool.crypto.CryptoException;
import com.xiaoleilu.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import com.xiaoleilu.hutool.crypto.asymmetric.DSA;
import com.xiaoleilu.hutool.crypto.asymmetric.RSA;
import com.xiaoleilu.hutool.crypto.asymmetric.Sign;
import com.xiaoleilu.hutool.crypto.asymmetric.SignAlgorithm;
import com.xiaoleilu.hutool.crypto.digest.DigestAlgorithm;
import com.xiaoleilu.hutool.crypto.digest.Digester;
import com.xiaoleilu.hutool.crypto.digest.HMac;
import com.xiaoleilu.hutool.crypto.digest.HmacAlgorithm;
import com.xiaoleilu.hutool.crypto.symmetric.AES;
import com.xiaoleilu.hutool.crypto.symmetric.DES;
import com.xiaoleilu.hutool.crypto.symmetric.DESede;
import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.RandomUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.File;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class SecureUtil {
    public static final int DEFAULT_KEY_SIZE = 1024;

    public static SecretKey generateKey(String algorithm) {
        return SecureUtil.generateKey(algorithm, -1);
    }

    public static SecretKey generateKey(String algorithm, int keySize) {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        if (keySize > 0) {
            keyGenerator.init(keySize);
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        Assert.notBlank(algorithm, "Algorithm is blank!", new Object[0]);
        SecretKey secretKey = null;
        secretKey = algorithm.startsWith("PBE") ? SecureUtil.generatePBEKey(algorithm, null == key ? null : StrUtil.str(key, CharsetUtil.CHARSET_UTF_8).toCharArray()) : (algorithm.startsWith("DES") ? SecureUtil.generateDESKey(algorithm, key) : (null == key ? SecureUtil.generateKey(algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        if (StrUtil.isBlank(algorithm) || !algorithm.startsWith("DES")) {
            throw new CryptoException("Algorithm [{}] is not a DES algorithm!");
        }
        SecretKey secretKey = null;
        if (null == key) {
            secretKey = SecureUtil.generateKey(algorithm);
        } else {
            KeySpec keySpec;
            try {
                keySpec = algorithm.startsWith("DESede") ? new DESedeKeySpec(key) : new DESKeySpec(key);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException(e);
            }
            secretKey = SecureUtil.generateKey(algorithm, keySpec);
        }
        return secretKey;
    }

    public static SecretKey generatePBEKey(String algorithm, char[] key) {
        if (StrUtil.isBlank(algorithm) || !algorithm.startsWith("PBE")) {
            throw new CryptoException("Algorithm [{}] is not a PBE algorithm!");
        }
        if (null == key) {
            key = RandomUtil.randomString(32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return SecureUtil.generateKey(algorithm, keySpec);
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
            return keyFactory.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        return SecureUtil.generatePrivateKey(algorithm, new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(String algorithm, KeySpec keySpec) {
        algorithm = SecureUtil.getAlgorithmAfterWith(algorithm);
        try {
            return KeyFactory.getInstance(algorithm).generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey generatePrivateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        return SecureUtil.generatePublicKey(algorithm, new X509EncodedKeySpec(key));
    }

    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        algorithm = SecureUtil.getAlgorithmAfterWith(algorithm);
        try {
            return KeyFactory.getInstance(algorithm).generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm) {
        return SecureUtil.generateKeyPair(algorithm, 1024, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        return SecureUtil.generateKeyPair(algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        KeyPairGenerator keyPairGen;
        if ("EC".equalsIgnoreCase(algorithm = SecureUtil.getAlgorithmAfterWith(algorithm)) && (keySize <= 0 || keySize > 256)) {
            keySize = 256;
        }
        try {
            keyPairGen = KeyPairGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        if (keySize <= 0) {
            keySize = 1024;
        }
        if (null != seed) {
            SecureRandom random = new SecureRandom(seed);
            keyPairGen.initialize(keySize, random);
        } else {
            keyPairGen.initialize(keySize);
        }
        return keyPairGen.generateKeyPair();
    }

    public static String getAlgorithmAfterWith(String algorithm) {
        Assert.notNull(algorithm, "algorithm must be not null !", new Object[0]);
        int indexOfWith = StrUtil.lastIndexOfIgnoreCase(algorithm, "with");
        if (indexOfWith > 0) {
            algorithm = StrUtil.subSuf(algorithm, indexOfWith + "with".length());
        }
        if ("ECDSA".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    public static Signature generateSignature(AsymmetricAlgorithm asymmetricAlgorithm, DigestAlgorithm digestAlgorithm) {
        String digestPart = null == digestAlgorithm ? "NONE" : digestAlgorithm.name();
        String algorithm = StrUtil.format((CharSequence)"{}with{}", digestPart, asymmetricAlgorithm.getValue());
        try {
            return Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }

    public static KeyStore readJKSKeyStore(InputStream in, char[] password) {
        return SecureUtil.readKeyStore("JKS", in, password);
    }

    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(in, password);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return keyStore;
    }

    public static Certificate readX509Certificate(InputStream in, char[] password) {
        return SecureUtil.readCertificate("X.509", in, password);
    }

    public static Certificate readCertificate(String type, InputStream in, char[] password) {
        Certificate certificate;
        try {
            certificate = CertificateFactory.getInstance(type).generateCertificate(in);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return certificate;
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static AES aes() {
        return new AES();
    }

    public static AES aes(byte[] key) {
        return new AES(key);
    }

    public static DES des() {
        return new DES();
    }

    public static DES des(byte[] key) {
        return new DES(key);
    }

    public static DESede desede() {
        return new DESede();
    }

    public static DESede desede(byte[] key) {
        return new DESede(key);
    }

    public static Digester md5() {
        return new Digester(DigestAlgorithm.MD5);
    }

    public static String md5(String data) {
        return new Digester(DigestAlgorithm.MD5).digestHex(data);
    }

    public static String md5(InputStream data) {
        return new Digester(DigestAlgorithm.MD5).digestHex(data);
    }

    public static String md5(File dataFile) {
        return new Digester(DigestAlgorithm.MD5).digestHex(dataFile);
    }

    public static Digester sha1() {
        return new Digester(DigestAlgorithm.SHA1);
    }

    public static String sha1(String data) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data);
    }

    public static String sha1(InputStream data) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data);
    }

    public static String sha1(File dataFile) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(dataFile);
    }

    public static HMac hmac(HmacAlgorithm algorithm, String key) {
        return new HMac(algorithm, StrUtil.utf8Bytes(key));
    }

    public static HMac hmac(HmacAlgorithm algorithm, byte[] key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmac(HmacAlgorithm algorithm, SecretKey key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmacMd5(String key) {
        return SecureUtil.hmacMd5(StrUtil.utf8Bytes(key));
    }

    public static HMac hmacMd5(byte[] key) {
        return new HMac(HmacAlgorithm.HmacMD5, key);
    }

    public static HMac hmacMd5() {
        return new HMac(HmacAlgorithm.HmacMD5);
    }

    public static HMac hmacSha1(String key) {
        return SecureUtil.hmacSha1(StrUtil.utf8Bytes(key));
    }

    public static HMac hmacSha1(byte[] key) {
        return new HMac(HmacAlgorithm.HmacSHA1, key);
    }

    public static HMac hmacSha1() {
        return new HMac(HmacAlgorithm.HmacSHA1);
    }

    public static RSA rsa() {
        return new RSA();
    }

    public static RSA rsa(String privateKeyBase64, String publicKeyBase64) {
        return new RSA(privateKeyBase64, publicKeyBase64);
    }

    public static RSA rsa(byte[] privateKey, byte[] publicKey) {
        return new RSA(privateKey, publicKey);
    }

    public static DSA dsa() {
        return new DSA();
    }

    public static DSA dsa(String privateKeyBase64, String publicKeyBase64) {
        return new DSA(privateKeyBase64, publicKeyBase64);
    }

    public static DSA dsa(byte[] privateKey, byte[] publicKey) {
        return new DSA(privateKey, publicKey);
    }

    public static Sign sign(SignAlgorithm algorithm) {
        return new Sign(algorithm);
    }

    public static Sign sign(SignAlgorithm algorithm, String privateKeyBase64, String publicKeyBase64) {
        return new Sign(algorithm, privateKeyBase64, publicKeyBase64);
    }

    public static Sign sign(SignAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        return new Sign(algorithm, privateKey, publicKey);
    }

    public static String simpleUUID() {
        return RandomUtil.simpleUUID();
    }
}

