/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.date;

import com.xiaoleilu.hutool.date.DateUnit;

public class BetweenFormater {
    private long betweenMs;
    private Level level;
    private int levelMaxCount;

    public BetweenFormater(long betweenMs, Level level) {
        this(betweenMs, level, 0);
    }

    public BetweenFormater(long betweenMs, Level level, int levelMaxCount) {
        this.betweenMs = betweenMs;
        this.level = level;
        this.levelMaxCount = levelMaxCount;
    }

    public String format() {
        if (this.betweenMs == 0L) {
            return "0";
        }
        long day = this.betweenMs / DateUnit.DAY.getMillis();
        long hour = this.betweenMs / DateUnit.HOUR.getMillis() - day * 24L;
        long minute = this.betweenMs / DateUnit.MINUTE.getMillis() - day * 24L * 60L - hour * 60L;
        long second = this.betweenMs / DateUnit.SECOND.getMillis() - ((day * 24L + hour) * 60L + minute) * 60L;
        long millisecond = this.betweenMs - (((day * 24L + hour) * 60L + minute) * 60L + second) * 1000L;
        StringBuilder sb = new StringBuilder();
        int level = this.level.value;
        int levelCount = 0;
        if (this.isLevelCountValid(levelCount) && 0L != day && level > 0) {
            sb.append(day).append("\u5929");
            ++levelCount;
        }
        if (this.isLevelCountValid(levelCount) && 0L != hour && level > 1) {
            sb.append(hour).append("\u5c0f\u65f6");
            ++levelCount;
        }
        if (this.isLevelCountValid(levelCount) && 0L != minute && level > 2) {
            sb.append(minute).append("\u5206");
            ++levelCount;
        }
        if (this.isLevelCountValid(levelCount) && 0L != second && level > 3) {
            sb.append(second).append("\u79d2");
            ++levelCount;
        }
        if (this.isLevelCountValid(levelCount) && 0L != millisecond && level > 4) {
            sb.append(millisecond).append("\u6beb\u79d2");
            ++levelCount;
        }
        return sb.toString();
    }

    public long getBetweenMs() {
        return this.betweenMs;
    }

    public void setBetweenMs(long betweenMs) {
        this.betweenMs = betweenMs;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public String toString() {
        return this.format();
    }

    private boolean isLevelCountValid(int levelCount) {
        return this.levelMaxCount <= 0 || levelCount < this.levelMaxCount;
    }

    public static enum Level {
        DAY(1),
        HOUR(2),
        MINUTE(3),
        SECOND(4),
        MILLSECOND(5);

        private int value;

        private Level(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

