/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.sql;

import com.xiaoleilu.hutool.collection.CollectionUtil;
import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.sql.Condition;
import com.xiaoleilu.hutool.util.ArrayUtil;
import java.util.Collection;

public class Query {
    Collection<String> fields;
    String[] tableNames;
    Condition[] where;
    Page page;

    public Query(String ... tableNames) {
        this((Condition[])null, tableNames);
        this.tableNames = tableNames;
    }

    public Query(Condition[] where, String ... tableNames) {
        this(where, (Page)null, tableNames);
    }

    public Query(Condition[] where, Page page, String ... tableNames) {
        this(null, tableNames, where, page);
    }

    public Query(Collection<String> fields, String[] tableNames, Condition[] where, Page page) {
        this.fields = fields;
        this.tableNames = tableNames;
        this.where = where;
        this.page = page;
    }

    public Collection<String> getFields() {
        return this.fields;
    }

    public Query setFields(Collection<String> fields) {
        this.fields = fields;
        return this;
    }

    public Query setFields(String ... fields) {
        this.fields = CollectionUtil.newArrayList(fields);
        return this;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public Query setTableNames(String ... tableNames) {
        this.tableNames = tableNames;
        return this;
    }

    public Condition[] getWhere() {
        return this.where;
    }

    public Query setWhere(Condition ... where) {
        this.where = where;
        return this;
    }

    public Page getPage() {
        return this.page;
    }

    public Query setPage(Page page) {
        this.page = page;
        return this;
    }

    public String getFirstTableName() throws DbRuntimeException {
        if (ArrayUtil.isEmpty(this.tableNames)) {
            throw new DbRuntimeException("No tableName!");
        }
        return this.tableNames[0];
    }
}

