/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.map;

import java.util.LinkedHashMap;
import java.util.Map;

public class CaseInsensitiveLinkedMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 4043263744224569870L;

    public CaseInsensitiveLinkedMap() {
    }

    public CaseInsensitiveLinkedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveLinkedMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CaseInsensitiveLinkedMap(Map<? extends K, ? extends V> m) {
        super((int)((double)m.size() / 0.75));
        this.putAll(m);
    }

    public CaseInsensitiveLinkedMap(float loadFactor, Map<? extends K, ? extends V> m) {
        super(m.size(), loadFactor);
        this.putAll(m);
    }

    @Override
    public V get(Object key) {
        return super.get(CaseInsensitiveLinkedMap.lowerCaseKey(key));
    }

    @Override
    public V put(K key, V value) {
        return super.put(CaseInsensitiveLinkedMap.lowerCaseKey(key), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(CaseInsensitiveLinkedMap.lowerCaseKey(key));
    }

    private static Object lowerCaseKey(Object key) {
        if (null != key && key instanceof CharSequence) {
            key = key.toString().toLowerCase();
        }
        return key;
    }
}

