/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.util.StrUtil;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";

    public static Document readXML(File file) {
        Assert.notNull(file, "Xml file is null !", new Object[0]);
        if (!file.exists()) {
            throw new UtilException("File [{}] not a exist!", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new UtilException("[{}] not a file!", file.getAbsolutePath());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return XmlUtil.readXML(new InputSource(file.toURI().toASCIIString()));
    }

    public static Document readXML(String pathOrContent) {
        if (StrUtil.startWith((CharSequence)pathOrContent, '<')) {
            return XmlUtil.parseXml(pathOrContent);
        }
        return XmlUtil.readXML(FileUtil.file(pathOrContent));
    }

    public static Document readXML(InputStream inputStream) throws UtilException {
        return XmlUtil.readXML(new InputSource(inputStream));
    }

    public static Document readXML(Reader reader) throws UtilException {
        return XmlUtil.readXML(new InputSource(reader));
    }

    public static Document readXML(InputSource source) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            return builder.parse(source);
        }
        catch (Exception e) {
            throw new UtilException(e, "Parse XML from stream error!", new Object[0]);
        }
    }

    public static Document parseXml(String xmlStr) {
        if (StrUtil.isBlank(xmlStr)) {
            throw new IllegalArgumentException("XML content string is empty !");
        }
        xmlStr = XmlUtil.cleanInvalid(xmlStr);
        return XmlUtil.readXML(new InputSource(StrUtil.getReader(xmlStr)));
    }

    public static <T> T readObjectFromXml(File source) throws IOException {
        return XmlUtil.readObjectFromXml(new InputSource(FileUtil.getInputStream(source)));
    }

    public static <T> T readObjectFromXml(String xmlStr) throws IOException {
        return XmlUtil.readObjectFromXml(new InputSource(StrUtil.getReader(xmlStr)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readObjectFromXml(InputSource source) throws IOException {
        Object result = null;
        XMLDecoder xmldec = null;
        try {
            xmldec = new XMLDecoder(source);
            result = xmldec.readObject();
        }
        catch (Throwable throwable) {
            IoUtil.close(xmldec);
            throw throwable;
        }
        IoUtil.close(xmldec);
        return (T)result;
    }

    public static String toStr(Document doc) {
        return XmlUtil.toStr(doc, null);
    }

    public static String toStr(Document doc, String charset) {
        return XmlUtil.toStr(doc, charset, true);
    }

    public static String toStr(Document doc, String charset, boolean isPretty) {
        StringWriter writer = StrUtil.getWriter();
        try {
            XmlUtil.write(doc, writer, isPretty);
        }
        catch (Exception e) {
            throw new UtilException(e, "Trans xml document to string error!", new Object[0]);
        }
        return writer.toString();
    }

    public static void toFile(Document doc, String absolutePath) {
        XmlUtil.toFile(doc, absolutePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(Document doc, String path, String charset) {
        if (StrUtil.isBlank(charset)) {
            charset = doc.getXmlEncoding();
        }
        if (StrUtil.isBlank(charset)) {
            charset = "UTF-8";
        }
        BufferedWriter writer = null;
        try {
            writer = FileUtil.getWriter(path, charset, false);
            XmlUtil.write(doc, writer, true);
        }
        catch (Throwable throwable) {
            IoUtil.close(writer);
            throw throwable;
        }
        IoUtil.close(writer);
    }

    public static void write(Document doc, Writer writer, boolean isPretty) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer xformer = factory.newTransformer();
            xformer.setOutputProperty("indent", isPretty ? "yes" : "no");
            xformer.transform(new DOMSource(doc), new StreamResult(writer));
        }
        catch (Exception e) {
            throw new UtilException("Trans xml document to string error!", e);
        }
    }

    public static Document createXml(String rootElementName) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new UtilException("Create xml document error!", e);
        }
        Document doc = builder.newDocument();
        doc.appendChild(doc.createElement(rootElementName));
        return doc;
    }

    public static Element getRootElement(Document doc) {
        return null == doc ? null : doc.getDocumentElement();
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll(INVALID_REGEX, "");
    }

    public static List<Element> getElements(Element element, String tagName) {
        NodeList nodeList = StrUtil.isBlank(tagName) ? element.getChildNodes() : element.getElementsByTagName(tagName);
        return XmlUtil.transElements(element, nodeList);
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public static String elementText(Element element, String tagName) {
        Element child = XmlUtil.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public static String elementText(Element element, String tagName, String defaultValue) {
        Element child = XmlUtil.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        return XmlUtil.transElements(null, nodeList);
    }

    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeObjectAsXml(File dest, T t) throws IOException {
        XMLEncoder xmlenc = null;
        try {
            xmlenc = new XMLEncoder(FileUtil.getOutputStream(dest));
            xmlenc.writeObject(t);
        }
        catch (Throwable throwable) {
            IoUtil.close(xmlenc);
            throw throwable;
        }
        IoUtil.close(xmlenc);
    }

    public static XPath createXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static Object getByXPath(String expression, Object source, QName returnType) {
        XPath xPath = XmlUtil.createXPath();
        try {
            if (source instanceof InputSource) {
                return xPath.evaluate(expression, (InputSource)source, returnType);
            }
            return xPath.evaluate(expression, source, returnType);
        }
        catch (XPathExpressionException e) {
            throw new UtilException(e);
        }
    }
}

