/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended;

import com.ximpleware.extended.IByteBuffer;
import com.ximpleware.extended.ParseExceptionHuge;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class XMLBuffer
implements IByteBuffer {
    byte[][] bufferArray;
    long length;

    public XMLBuffer() {
    }

    public XMLBuffer(byte[] ba) {
        if (ba == null) {
            throw new IllegalArgumentException("ba can't be null ");
        }
        if (ba.length > 0x40000000) {
            throw new IllegalArgumentException("ba should be shorter than 1G bytes ");
        }
        this.bufferArray = new byte[1][];
        this.bufferArray[0] = ba;
        this.length = ba.length;
    }

    public void readFile(String fileName) throws IOException, ParseExceptionHuge {
        long l;
        File f = new File(fileName);
        this.length = l = f.length();
        if (l >= 0x4000000000L) {
            throw new ParseExceptionHuge("document too big > 256 Gbyte");
        }
        int pageNumber = (int)(l >> 30) + ((l & 0x3FFFFFFFL) == 0L ? 0 : 1);
        this.bufferArray = new byte[pageNumber][];
        FileInputStream fis = new FileInputStream(f);
        int byteArrayLen = 0;
        for (int i = 0; i < pageNumber; ++i) {
            if (l > 0x40000000L) {
                this.bufferArray[i] = new byte[0x40000000];
                byteArrayLen = 0x40000000;
            } else {
                this.bufferArray[i] = new byte[(int)l];
                byteArrayLen = (int)l;
            }
            int offset = 0;
            int numRead = 0;
            int numOfBytes = 0x100000;
            if (byteArrayLen - offset < numOfBytes) {
                numOfBytes = byteArrayLen - offset;
            }
            while (offset < byteArrayLen && (numRead = fis.read(this.bufferArray[i], offset, numOfBytes)) >= 0) {
                if (byteArrayLen - (offset += numRead) >= numOfBytes) continue;
                numOfBytes = byteArrayLen - offset;
            }
            l -= 0x40000000L;
        }
    }

    @Override
    public final byte byteAt(long index) {
        return this.bufferArray[(int)(index >> 30)][(int)(index & 0x3FFFFFFFL)];
    }

    @Override
    public byte[] getBytes(int offset, int len) {
        return null;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public void writeToFileOutputStream(FileOutputStream ost, long os, long len) throws IOException {
        int pageN = (int)(os >> 30);
        int pos = (int)(os & 0x3FFFFFFFL);
        if ((long)pos + len <= 0x40000000L) {
            ost.write(this.bufferArray[pageN], pos, (int)len);
            return;
        }
        ost.write(this.bufferArray[pageN], pos, 0x40000000 - pos);
        ++pageN;
        len -= (long)(0x40000000 - pos);
        while (len > 0x40000000L) {
            ost.write(this.bufferArray[pageN], 0, 0x40000000);
            ++pageN;
            len -= 0x40000000L;
        }
        ost.write(this.bufferArray[pageN], 0, (int)len);
    }
}

