/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.transcode;

import com.ximpleware.TranscodeException;
import com.ximpleware.transcode.ASCII_Coder;
import com.ximpleware.transcode.ISO8859_1Coder;
import com.ximpleware.transcode.UTF16BE_Coder;
import com.ximpleware.transcode.UTF16LE_Coder;
import com.ximpleware.transcode.UTF8_Coder;
import java.io.IOException;
import java.io.OutputStream;

public class Transcoder {
    public static byte[] transcode(byte[] input, int offset, int length, int input_encoding, int output_encoding) throws TranscodeException {
        int i = Transcoder.getOutLength(input, offset, length, input_encoding, output_encoding);
        byte[] output = new byte[i];
        Transcoder.transcodeAndFill(input, output, offset, length, input_encoding, output_encoding);
        return output;
    }

    public static final int getOutLength(byte[] input, int offset, int length, int input_encoding, int output_encoding) throws TranscodeException {
        int len = 0;
        int k = offset;
        while (k < offset + length) {
            long l = Transcoder.decode(input, k, input_encoding);
            k = (int)(l >> 32);
            int c = (int)l;
            len += Transcoder.getLen(c, output_encoding);
        }
        return len;
    }

    public static final void transcodeAndFill(byte[] input, byte[] output, int offset, int length, int input_encoding, int output_encoding) throws TranscodeException {
        int k = offset;
        int i = 0;
        while (k < offset + length) {
            long l = Transcoder.decode(input, k, input_encoding);
            k = (int)(l >> 32);
            int c = (int)l;
            i = Transcoder.encode(output, i, c, output_encoding);
        }
    }

    public static final int transcodeAndFill2(int initOutPosition, byte[] input, byte[] output, int offset, int length, int input_encoding, int output_encoding) throws TranscodeException {
        int k = offset;
        int i = initOutPosition;
        while (k < offset + length) {
            long l = Transcoder.decode(input, k, input_encoding);
            k = (int)(l >> 32);
            int c = (int)l;
            i = Transcoder.encode(output, i, c, output_encoding);
        }
        return i;
    }

    public static final void transcodeAndWrite(byte[] input, OutputStream os, int offset, int length, int input_encoding, int output_encoding) throws TranscodeException, IOException {
        int k = offset;
        while (k < offset + length) {
            long l = Transcoder.decode(input, k, input_encoding);
            k = (int)(l >> 32);
            int c = (int)l;
            Transcoder.encodeAndWrite(os, c, output_encoding);
        }
    }

    public static final int getLen(int ch, int output_encoding) throws TranscodeException {
        switch (output_encoding) {
            case 0: {
                return ASCII_Coder.getLen(ch);
            }
            case 2: {
                return UTF8_Coder.getLen(ch);
            }
            case 1: {
                return ISO8859_1Coder.getLen(ch);
            }
            case 64: {
                return UTF16LE_Coder.getLen(ch);
            }
            case 63: {
                return UTF16BE_Coder.getLen(ch);
            }
        }
        throw new TranscodeException("Unsupported encoding");
    }

    public static final long decode(byte[] input, int offset, int input_encoding) throws TranscodeException {
        switch (input_encoding) {
            case 0: {
                return ASCII_Coder.decode(input, offset);
            }
            case 2: {
                return UTF8_Coder.decode(input, offset);
            }
            case 1: {
                return ISO8859_1Coder.decode(input, offset);
            }
            case 64: {
                return UTF16LE_Coder.decode(input, offset);
            }
            case 63: {
                return UTF16BE_Coder.decode(input, offset);
            }
        }
        throw new TranscodeException("Unsupported encoding");
    }

    public static final int encode(byte[] output, int offset, int ch, int output_encoding) throws TranscodeException {
        switch (output_encoding) {
            case 0: {
                return ASCII_Coder.encode(output, offset, ch);
            }
            case 2: {
                return UTF8_Coder.encode(output, offset, ch);
            }
            case 1: {
                return ISO8859_1Coder.encode(output, offset, ch);
            }
            case 64: {
                return UTF16LE_Coder.encode(output, offset, ch);
            }
            case 63: {
                return UTF16BE_Coder.encode(output, offset, ch);
            }
        }
        throw new TranscodeException("Unsupported encoding");
    }

    public static final void encodeAndWrite(OutputStream os, int ch, int output_encoding) throws TranscodeException, IOException {
        switch (output_encoding) {
            case 0: {
                ASCII_Coder.encodeAndWrite(os, ch);
                return;
            }
            case 2: {
                UTF8_Coder.encodeAndWrite(os, ch);
                return;
            }
            case 1: {
                ISO8859_1Coder.encodeAndWrite(os, ch);
                return;
            }
            case 64: {
                UTF16LE_Coder.encodeAndWrite(os, ch);
                return;
            }
            case 63: {
                UTF16BE_Coder.encodeAndWrite(os, ch);
                return;
            }
        }
        throw new TranscodeException("Unsupported encoding");
    }
}

