/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.http.HttpUtil;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.GlobalAuthUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;
import java.util.HashMap;
import java.util.Optional;
import java.util.TreeMap;

public class AuthXmlyRequest
extends AuthDefaultRequest {
    public AuthXmlyRequest(AuthConfig config) {
        super(config, AuthDefaultSource.XMLY);
    }

    public AuthXmlyRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.XMLY, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("code", authCallback.getCode());
        map.put("client_id", this.config.getClientId());
        map.put("client_secret", this.config.getClientSecret());
        map.put("device_id", this.config.getDeviceId());
        map.put("grant_type", "authorization_code");
        map.put("redirect_uri", this.config.getRedirectUri());
        String response = HttpUtil.post((String)this.source.accessToken(), map, (boolean)true).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).refreshToken(accessTokenObject.getString("refresh_token")).expireIn(accessTokenObject.getIntValue("expires_in")).uid(accessTokenObject.getString("uid")).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("client_os_type", "3").queryParam("device_id", this.config.getDeviceId()).build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("app_key", this.config.getClientId());
        map.put("client_os_type", Optional.ofNullable(this.config.getClientOsType()).orElse(3).toString());
        map.put("device_id", this.config.getDeviceId());
        map.put("pack_id", this.config.getPackId());
        map.put("access_token", authToken.getAccessToken());
        map.put("sig", GlobalAuthUtils.generateXmlySignature(map, this.config.getClientSecret()));
        String rawUserInfo = HttpUtil.get((String)this.source.userInfo(), map, (boolean)false).getBody();
        JSONObject object = JSONObject.parseObject((String)rawUserInfo);
        this.checkResponse(object);
        return AuthUser.builder().uuid(object.getString("id")).nickname(object.getString("nickname")).avatar(object.getString("avatar_url")).rawUserInfo(object).source(this.source.toString()).token(authToken).gender(AuthUserGender.UNKNOWN).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"errcode")) {
            throw new AuthException(object.getIntValue("error_no"), object.getString("error_desc"));
        }
    }
}

