/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.http.util;

import com.xingyuv.http.util.StringUtil;
import com.xingyuv.http.util.UrlUtil;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class MapUtil {
    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return !MapUtil.isNotEmpty(map);
    }

    public static <K, V> void forEach(Map<K, V> map, BiConsumer<? super K, ? super V> action) {
        if (MapUtil.isEmpty(map) || action == null) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            action.accept(k, v);
        }
    }

    public static String parseMapToString(Map<String, String> params, boolean encode) {
        ArrayList paramList = new ArrayList();
        MapUtil.forEach(params, (k, v) -> {
            if (v == null) {
                paramList.add(k + "=");
            } else {
                paramList.add(k + "=" + (encode ? UrlUtil.urlEncode(v) : v));
            }
        });
        return String.join((CharSequence)"&", paramList);
    }

    public static Map<String, String> parseStringToMap(String str, boolean decode) {
        int i;
        str = MapUtil.preProcess(str);
        HashMap<String, String> params = new HashMap<String, String>(16);
        if (StringUtil.isEmpty(str)) {
            return params;
        }
        if (!str.contains("&")) {
            params.put(MapUtil.decode(str, decode), "");
            return params;
        }
        int len = str.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '=') {
                if (null == name) {
                    name = str.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (null == name && pos != i) {
                MapUtil.addParam(params, str.substring(pos, i), "", decode);
            } else if (name != null) {
                MapUtil.addParam(params, name, str.substring(pos, i), decode);
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                MapUtil.addParam(params, str.substring(pos, i), "", decode);
            } else {
                MapUtil.addParam(params, name, str.substring(pos, i), decode);
            }
        } else if (name != null) {
            MapUtil.addParam(params, name, "", decode);
        }
        return params;
    }

    private static void addParam(Map<String, String> params, String key, String value, boolean decode) {
        key = MapUtil.decode(key, decode);
        value = MapUtil.decode(value, decode);
        if (params.containsKey(key)) {
            params.put(key, params.get(key) + "," + value);
        } else {
            params.put(key, value);
        }
    }

    private static String decode(String str, boolean decode) {
        return decode ? UrlUtil.urlDecode(str) : str;
    }

    private static String preProcess(String str) {
        int endPos;
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        int beginPos = str.indexOf("?");
        if (beginPos > -1) {
            str = str.substring(beginPos + 1);
        }
        if ((endPos = str.indexOf("#")) > -1) {
            str = str.substring(0, endPos);
        }
        return str;
    }

    private MapUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

