/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.justauth;

import com.xkcoding.justauth.properties.JustAuthProperties;
import java.util.List;
import java.util.stream.Collectors;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.request.AuthAlipayRequest;
import me.zhyd.oauth.request.AuthBaiduRequest;
import me.zhyd.oauth.request.AuthCodingRequest;
import me.zhyd.oauth.request.AuthCsdnRequest;
import me.zhyd.oauth.request.AuthDingTalkRequest;
import me.zhyd.oauth.request.AuthDouyinRequest;
import me.zhyd.oauth.request.AuthFacebookRequest;
import me.zhyd.oauth.request.AuthGiteeRequest;
import me.zhyd.oauth.request.AuthGithubRequest;
import me.zhyd.oauth.request.AuthGoogleRequest;
import me.zhyd.oauth.request.AuthHuaweiRequest;
import me.zhyd.oauth.request.AuthLinkedinRequest;
import me.zhyd.oauth.request.AuthMiRequest;
import me.zhyd.oauth.request.AuthMicrosoftRequest;
import me.zhyd.oauth.request.AuthOschinaRequest;
import me.zhyd.oauth.request.AuthPinterestRequest;
import me.zhyd.oauth.request.AuthQqRequest;
import me.zhyd.oauth.request.AuthRenrenRequest;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.request.AuthStackOverflowRequest;
import me.zhyd.oauth.request.AuthTaobaoRequest;
import me.zhyd.oauth.request.AuthTeambitionRequest;
import me.zhyd.oauth.request.AuthTencentCloudRequest;
import me.zhyd.oauth.request.AuthToutiaoRequest;
import me.zhyd.oauth.request.AuthWeChatEnterpriseRequest;
import me.zhyd.oauth.request.AuthWeChatRequest;
import me.zhyd.oauth.request.AuthWeiboRequest;

public class AuthRequestFactory {
    private final JustAuthProperties properties;
    private final AuthStateCache authStateCache;

    public List<String> oauthList() {
        return this.properties.getType().keySet().stream().map(Enum::name).collect(Collectors.toList());
    }

    public AuthRequest get(AuthSource source) {
        AuthConfig config = this.properties.getType().get(source);
        switch (source) {
            case GITHUB: {
                return new AuthGithubRequest(config, this.authStateCache);
            }
            case WEIBO: {
                return new AuthWeiboRequest(config, this.authStateCache);
            }
            case GITEE: {
                return new AuthGiteeRequest(config, this.authStateCache);
            }
            case DINGTALK: {
                return new AuthDingTalkRequest(config, this.authStateCache);
            }
            case BAIDU: {
                return new AuthBaiduRequest(config, this.authStateCache);
            }
            case CSDN: {
                return new AuthCsdnRequest(config, this.authStateCache);
            }
            case CODING: {
                return new AuthCodingRequest(config, this.authStateCache);
            }
            case TENCENT_CLOUD: {
                return new AuthTencentCloudRequest(config, this.authStateCache);
            }
            case OSCHINA: {
                return new AuthOschinaRequest(config, this.authStateCache);
            }
            case ALIPAY: {
                return new AuthAlipayRequest(config, this.authStateCache);
            }
            case QQ: {
                return new AuthQqRequest(config, this.authStateCache);
            }
            case WECHAT: {
                return new AuthWeChatRequest(config, this.authStateCache);
            }
            case TAOBAO: {
                return new AuthTaobaoRequest(config, this.authStateCache);
            }
            case GOOGLE: {
                return new AuthGoogleRequest(config, this.authStateCache);
            }
            case FACEBOOK: {
                return new AuthFacebookRequest(config, this.authStateCache);
            }
            case DOUYIN: {
                return new AuthDouyinRequest(config, this.authStateCache);
            }
            case LINKEDIN: {
                return new AuthLinkedinRequest(config, this.authStateCache);
            }
            case MICROSOFT: {
                return new AuthMicrosoftRequest(config, this.authStateCache);
            }
            case MI: {
                return new AuthMiRequest(config, this.authStateCache);
            }
            case TOUTIAO: {
                return new AuthToutiaoRequest(config, this.authStateCache);
            }
            case TEAMBITION: {
                return new AuthTeambitionRequest(config, this.authStateCache);
            }
            case RENREN: {
                return new AuthRenrenRequest(config, this.authStateCache);
            }
            case PINTEREST: {
                return new AuthPinterestRequest(config, this.authStateCache);
            }
            case STACK_OVERFLOW: {
                return new AuthStackOverflowRequest(config, this.authStateCache);
            }
            case HUAWEI: {
                return new AuthHuaweiRequest(config, this.authStateCache);
            }
            case WECHAT_ENTERPRISE: {
                return new AuthWeChatEnterpriseRequest(config, this.authStateCache);
            }
        }
        throw new AuthException(AuthResponseStatus.UNSUPPORTED);
    }

    public AuthRequestFactory(JustAuthProperties properties, AuthStateCache authStateCache) {
        this.properties = properties;
        this.authStateCache = authStateCache;
    }
}

