/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.executor;

import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.biz.impl.ExecutorBizImpl;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHander;
import com.xxl.job.core.registry.RegistHelper;
import com.xxl.job.core.rpc.netcom.NetComServerFactory;
import com.xxl.job.core.thread.ExecutorRegistryThread;
import com.xxl.job.core.thread.JobThread;
import com.xxl.job.core.thread.TriggerCallbackThread;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class XxlJobExecutor
implements ApplicationContextAware,
ApplicationListener {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobExecutor.class);
    private String ip;
    private int port = 9999;
    private String appName;
    private RegistHelper registHelper;
    private NetComServerFactory serverFactory = new NetComServerFactory();
    private static ConcurrentHashMap<String, IJobHandler> jobHandlerRepository = new ConcurrentHashMap();
    private static ConcurrentHashMap<Integer, JobThread> JobThreadRepository = new ConcurrentHashMap();

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setRegistHelper(RegistHelper registHelper) {
        this.registHelper = registHelper;
    }

    public void start() throws Exception {
        NetComServerFactory.putService(ExecutorBiz.class, new ExecutorBizImpl());
        this.serverFactory.start(this.port, this.ip, this.appName, this.registHelper);
        TriggerCallbackThread.getInstance().start();
    }

    public void destroy() {
        this.serverFactory.destroy();
        if (JobThreadRepository.size() > 0) {
            for (Map.Entry<Integer, JobThread> item : JobThreadRepository.entrySet()) {
                JobThread jobThread = item.getValue();
                jobThread.toStop("Web\u5bb9\u5668\u9500\u6bc1\u7ec8\u6b62");
                jobThread.interrupt();
            }
            JobThreadRepository.clear();
        }
        TriggerCallbackThread.getInstance().toStop();
        ExecutorRegistryThread.getInstance().toStop();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map serviceBeanMap = applicationContext.getBeansWithAnnotation(JobHander.class);
        if (serviceBeanMap != null && serviceBeanMap.size() > 0) {
            for (Object serviceBean : serviceBeanMap.values()) {
                if (!(serviceBean instanceof IJobHandler)) continue;
                String name = serviceBean.getClass().getAnnotation(JobHander.class).value();
                IJobHandler handler = (IJobHandler)serviceBean;
                XxlJobExecutor.registJobHandler(name, handler);
            }
        }
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ContextClosedEvent) {
            // empty if block
        }
    }

    public static IJobHandler registJobHandler(String name, IJobHandler jobHandler) {
        logger.info("xxl-job register jobhandler success, name:{}, jobHandler:{}", (Object)name, (Object)jobHandler);
        return jobHandlerRepository.put(name, jobHandler);
    }

    public static IJobHandler loadJobHandler(String name) {
        return jobHandlerRepository.get(name);
    }

    public static JobThread registJobThread(int jobId, IJobHandler handler) {
        JobThread jobThread = new JobThread(handler);
        jobThread.start();
        logger.info(">>>>>>>>>>> xxl-job regist JobThread success, jobId:{}, handler:{}", new Object[]{jobId, handler});
        JobThreadRepository.put(jobId, jobThread);
        return jobThread;
    }

    public static JobThread loadJobThread(int jobId) {
        JobThread jobThread = JobThreadRepository.get(jobId);
        return jobThread;
    }

    public static void removeJobThread(int jobId) {
        JobThreadRepository.remove(jobId);
    }
}

