/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.glue;

import com.xxl.job.core.glue.loader.GlueLoader;
import com.xxl.job.core.handler.IJobHandler;
import groovy.lang.GroovyClassLoader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;

public class GlueFactory
implements ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(GlueFactory.class);
    private GroovyClassLoader groovyClassLoader = new GroovyClassLoader();
    private GlueLoader glueLoader;
    private static ApplicationContext applicationContext;
    private static GlueFactory glueFactory;

    public void setGlueLoader(GlueLoader glueLoader) {
        this.glueLoader = glueLoader;
    }

    public static boolean isActive() {
        return GlueFactory.glueFactory.glueLoader != null;
    }

    public static GlueFactory getInstance() {
        return glueFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        GlueFactory.applicationContext = applicationContext;
        glueFactory = (GlueFactory)applicationContext.getBean("glueFactory");
    }

    public void injectService(Object instance) {
        Field[] fields;
        if (instance == null) {
            return;
        }
        for (Field field : fields = instance.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Object fieldBean = null;
            if (AnnotationUtils.getAnnotation((AnnotatedElement)field, Resource.class) != null) {
                try {
                    Resource resource = (Resource)AnnotationUtils.getAnnotation((AnnotatedElement)field, Resource.class);
                    fieldBean = resource.name() != null && resource.name().length() > 0 ? applicationContext.getBean(resource.name()) : applicationContext.getBean(field.getName());
                }
                catch (Exception resource) {
                    // empty catch block
                }
                if (fieldBean == null) {
                    fieldBean = applicationContext.getBean(field.getType());
                }
            } else if (AnnotationUtils.getAnnotation((AnnotatedElement)field, Autowired.class) != null) {
                Qualifier qualifier = (Qualifier)AnnotationUtils.getAnnotation((AnnotatedElement)field, Qualifier.class);
                fieldBean = qualifier != null && qualifier.value() != null && qualifier.value().length() > 0 ? applicationContext.getBean(qualifier.value()) : applicationContext.getBean(field.getType());
            }
            if (fieldBean == null) continue;
            field.setAccessible(true);
            try {
                field.set(instance, fieldBean);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public IJobHandler loadNewInstance(int jobId) throws Exception {
        Object instance;
        Class clazz;
        if (jobId == 0) {
            return null;
        }
        String codeSource = this.glueLoader.load(jobId);
        if (codeSource != null && codeSource.trim().length() > 0 && (clazz = this.groovyClassLoader.parseClass(codeSource)) != null && (instance = clazz.newInstance()) != null) {
            if (instance instanceof IJobHandler) {
                this.injectService(instance);
                return (IJobHandler)instance;
            }
            throw new IllegalArgumentException(">>>>>>>>>>> xxl-glue, loadNewInstance error, cannot convert from instance[" + instance.getClass() + "] to IJobHandler");
        }
        throw new IllegalArgumentException(">>>>>>>>>>> xxl-glue, loadNewInstance error, instance is null");
    }
}

