/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.log;

import com.xxl.job.core.biz.model.LogResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class XxlJobFileAppender
extends AppenderSkeleton {
    public static ThreadLocal<String> contextHolder = new ThreadLocal();
    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    public static volatile String filePath;

    public void setFilePath(String filePath) {
        XxlJobFileAppender.filePath = filePath;
    }

    public static String makeLogFileName(Date triggerDate, int logId) {
        String nowFormat;
        File filePathDateDir;
        File filePathDir = new File(filePath);
        if (!filePathDir.exists()) {
            filePathDir.mkdirs();
        }
        if (!(filePathDateDir = new File(filePathDir, nowFormat = sdf.format(new Date()))).exists()) {
            filePathDateDir.mkdirs();
        }
        String logFileName = sdf.format(triggerDate).concat("/").concat(String.valueOf(logId)).concat(".log");
        return logFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        String logFileName = contextHolder.get();
        if (logFileName == null || logFileName.trim().length() == 0) {
            return;
        }
        File logFile = new File(filePath, logFileName);
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            FileOutputStream fos = null;
            try {
                String[] throwableInfo;
                fos = new FileOutputStream(logFile, true);
                fos.write(this.layout.format(event).getBytes("utf-8"));
                if (this.layout.ignoresThrowable() && (throwableInfo = event.getThrowableStrRep()) != null) {
                    for (int i = 0; i < throwableInfo.length; ++i) {
                        fos.write(throwableInfo[i].getBytes("utf-8"));
                        fos.write(Layout.LINE_SEP.getBytes("utf-8"));
                    }
                }
                fos.flush();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogResult readLog(String logFileName, int fromLineNum) {
        if (logFileName == null || logFileName.trim().length() == 0) {
            return new LogResult(fromLineNum, -1, "readLog fail, logFile not found", true);
        }
        File logFile = new File(filePath, logFileName);
        if (!logFile.exists()) {
            return new LogResult(fromLineNum, -1, "readLog fail, logFile not exists", true);
        }
        StringBuffer logContentBuffer = new StringBuffer();
        int toLineNum = 0;
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(logFile));
            String line = null;
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                ++toLineNum;
                if (((LineNumberReader)reader).getLineNumber() < fromLineNum) continue;
                logContentBuffer.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        LogResult logResult = new LogResult(fromLineNum, toLineNum, logContentBuffer.toString(), false);
        return logResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLines(File logFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFile), "utf-8"));
            if (reader != null) {
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                String string = sb.toString();
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

