/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.thread;

import com.xxl.job.core.biz.model.HandleCallbackParam;
import com.xxl.job.core.biz.model.TriggerParam;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.thread.TriggerCallbackThread;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobThread
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(JobThread.class);
    private IJobHandler handler;
    private LinkedBlockingQueue<TriggerParam> triggerQueue;
    private ConcurrentHashSet<Integer> triggerLogIdSet;
    private boolean toStop = false;
    private String stopReason;
    int i = 1;

    public JobThread(IJobHandler handler) {
        this.handler = handler;
        this.triggerQueue = new LinkedBlockingQueue();
        this.triggerLogIdSet = new ConcurrentHashSet();
    }

    public IJobHandler getHandler() {
        return this.handler;
    }

    public void pushTriggerQueue(TriggerParam triggerParam) {
        if (this.triggerLogIdSet.contains((Object)triggerParam.getLogId())) {
            logger.debug("repeate trigger job, logId:{}", (Object)triggerParam.getLogId());
            return;
        }
        this.triggerLogIdSet.add((Object)triggerParam.getLogId());
        this.triggerQueue.add(triggerParam);
    }

    public void toStop(String stopReason) {
        this.toStop = true;
        this.stopReason = stopReason;
    }

    @Override
    public void run() {
        TriggerParam triggerParam;
        while (!this.toStop) {
            try {
                triggerParam = this.triggerQueue.poll(3L, TimeUnit.SECONDS);
                if (triggerParam == null) continue;
                this.triggerLogIdSet.remove((Object)triggerParam.getLogId());
                String[] handlerParams = triggerParam.getExecutorParams() != null && triggerParam.getExecutorParams().trim().length() > 0 ? (String[])Arrays.asList(triggerParam.getExecutorParams().split(",")).toArray() : null;
                int _code = 200;
                String _msg = null;
                try {
                    String logFileName = XxlJobFileAppender.makeLogFileName(new Date(triggerParam.getLogDateTim()), triggerParam.getLogId());
                    XxlJobFileAppender.contextHolder.set(logFileName);
                    logger.info("----------- xxl-job job execute start -----------");
                    this.handler.execute(handlerParams);
                }
                catch (Exception e) {
                    logger.error("JobThread Exception:", (Throwable)e);
                    _code = 500;
                    StringWriter out = new StringWriter();
                    e.printStackTrace(new PrintWriter(out));
                    _msg = out.toString();
                }
                logger.info("----------- xxl-job job execute end ----------- <br> Look : ExecutorParams:{}, Code:{}, Msg:{}", new Object[]{handlerParams, _code, _msg});
                if (!this.toStop) {
                    TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogAddress(), _code, _msg));
                    continue;
                }
                TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogAddress(), 500, this.stopReason + " [\u4e1a\u52a1\u8fd0\u884c\u4e2d\uff0c\u88ab\u5f3a\u5236\u7ec8\u6b62]"));
            }
            catch (Exception e) {
                logger.error("----------- xxl-job JobThread Exception:", (Throwable)e);
            }
        }
        while (this.triggerQueue != null && this.triggerQueue.size() > 0) {
            triggerParam = this.triggerQueue.poll();
            if (triggerParam == null) continue;
            TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogAddress(), 500, this.stopReason + " [\u4efb\u52a1\u5c1a\u672a\u6267\u884c\uff0c\u5728\u8c03\u5ea6\u961f\u5217\u4e2d\u88ab\u7ec8\u6b62]"));
        }
        logger.info(">>>>>>>>>>>> xxl-job JobThread stoped, hashCode:{}", (Object)Thread.currentThread());
    }
}

