/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.log;

import com.xxl.job.core.log.XxlJobFileAppender;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlJobLogger {
    private static Logger logger = LoggerFactory.getLogger((String)"xxl-job logger");
    private static SimpleDateFormat xxlJobLoggerFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static void logDetail(StackTraceElement callInfo, String appendLog) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(xxlJobLoggerFormat.format(new Date())).append(" ").append("[" + callInfo.getClassName() + "#" + callInfo.getMethodName() + "]").append("-").append("[" + callInfo.getLineNumber() + "]").append("-").append("[" + Thread.currentThread().getName() + "]").append(" ").append(appendLog != null ? appendLog : "");
        String formatAppendLog = stringBuffer.toString();
        String logFileName = (String)XxlJobFileAppender.contextHolder.get();
        if (logFileName != null && logFileName.trim().length() > 0) {
            XxlJobFileAppender.appendLog(logFileName, formatAppendLog);
        } else {
            logger.info(">>>>>>>>>>> {}", (Object)formatAppendLog);
        }
    }

    public static void log(String appendLogPattern, Object ... appendLogArguments) {
        String appendLog = appendLogPattern;
        if (appendLogArguments != null && appendLogArguments.length > 0) {
            appendLog = MessageFormat.format(appendLogPattern, appendLogArguments);
        }
        StackTraceElement callInfo = new Throwable().getStackTrace()[1];
        XxlJobLogger.logDetail(callInfo, appendLog);
    }

    public static void log(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String appendLog = stringWriter.toString();
        StackTraceElement callInfo = new Throwable().getStackTrace()[1];
        XxlJobLogger.logDetail(callInfo, appendLog);
    }
}

