/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.glue;

import com.xxl.job.core.glue.impl.SpringGlueFactory;
import com.xxl.job.core.handler.IJobHandler;
import groovy.lang.GroovyClassLoader;

public class GlueFactory {
    private static GlueFactory glueFactory = new GlueFactory();
    private GroovyClassLoader groovyClassLoader = new GroovyClassLoader();

    public static GlueFactory getInstance() {
        return glueFactory;
    }

    public static void refreshInstance(int type) {
        if (type == 0) {
            glueFactory = new GlueFactory();
        } else if (type == 1) {
            glueFactory = new SpringGlueFactory();
        }
    }

    public IJobHandler loadNewInstance(String codeSource) throws Exception {
        Object instance;
        Class clazz;
        if (codeSource != null && codeSource.trim().length() > 0 && (clazz = this.groovyClassLoader.parseClass(codeSource)) != null && (instance = clazz.newInstance()) != null) {
            if (instance instanceof IJobHandler) {
                this.injectService(instance);
                return (IJobHandler)instance;
            }
            throw new IllegalArgumentException(">>>>>>>>>>> xxl-glue, loadNewInstance error, cannot convert from instance[" + instance.getClass() + "] to IJobHandler");
        }
        throw new IllegalArgumentException(">>>>>>>>>>> xxl-glue, loadNewInstance error, instance is null");
    }

    public void injectService(Object instance) {
    }
}

