/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.mina.client;

import com.xxl.rpc.remoting.net.impl.mina.client.MinaClientHandler;
import com.xxl.rpc.remoting.net.impl.mina.codec.MinaDecoder;
import com.xxl.rpc.remoting.net.impl.mina.codec.MinaEncoder;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.remoting.net.pool.ClientPooled;
import com.xxl.rpc.serialize.Serializer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.transport.socket.DefaultSocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class MinaPooledClient
extends ClientPooled {
    private NioSocketConnector connector;
    private IoSession ioSession;

    @Override
    public void init(String host, int port, final Serializer serializer) {
        this.connector = new NioSocketConnector();
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(new ProtocolCodecFactory(){

            public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                return new MinaEncoder(XxlRpcRequest.class, serializer);
            }

            public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                return new MinaDecoder(XxlRpcResponse.class, serializer);
            }
        }));
        this.connector.setHandler((IoHandler)new MinaClientHandler());
        this.connector.setConnectTimeoutMillis(5000L);
        DefaultSocketSessionConfig sessionConfiguration = (DefaultSocketSessionConfig)this.connector.getSessionConfig();
        sessionConfiguration.setReadBufferSize(1024);
        sessionConfiguration.setSendBufferSize(512);
        sessionConfiguration.setReuseAddress(true);
        sessionConfiguration.setTcpNoDelay(true);
        sessionConfiguration.setKeepAlive(true);
        sessionConfiguration.setSoLinger(-1);
        sessionConfiguration.setWriteTimeout(5);
        ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(host, port));
        future.awaitUninterruptibly(5L, TimeUnit.SECONDS);
        if (!future.isConnected()) {
            logger.error(">>>>>>>>>>>> xxl-rpc mina client proxy, connect to server fail at host:{}, port:{}", (Object)host, (Object)port);
            this.connector.dispose();
            this.connector = null;
            return;
        }
        this.ioSession = future.getSession();
        logger.debug(">>>>>>>>>>>> xxl-rpc mina client proxy, connect to server success at host:{}, port:{}", (Object)host, (Object)port);
    }

    @Override
    public boolean isValidate() {
        if (this.ioSession != null && this.connector != null) {
            return this.connector.isActive() && this.ioSession.isConnected();
        }
        return false;
    }

    @Override
    public void close() {
        if (this.ioSession != null) {
            if (this.ioSession.isConnected()) {
                this.ioSession.getCloseFuture().awaitUninterruptibly();
            }
            this.ioSession.closeNow();
            this.ioSession = null;
        }
        if (this.connector != null) {
            this.connector.dispose();
            this.connector = null;
        }
        logger.debug(">>>>>>>>>>>> xxl-rpc mina client close.");
    }

    @Override
    public void send(XxlRpcRequest xxlRpcRequest) {
        this.ioSession.write((Object)xxlRpcRequest);
    }
}

