/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.common;

import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.invoker.reference.XxlRpcReferenceBean;
import com.xxl.rpc.remoting.net.params.BaseCallback;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.serialize.Serializer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectClient {
    protected static transient Logger logger = LoggerFactory.getLogger(ConnectClient.class);
    private static volatile ConcurrentHashMap<String, ConnectClient> connectClientMap;
    private static volatile ConcurrentHashMap<String, Object> connectClientLockMap;

    public abstract void init(String var1, Serializer var2, XxlRpcInvokerFactory var3) throws Exception;

    public abstract void close();

    public abstract boolean isValidate();

    public abstract void send(XxlRpcRequest var1) throws Exception;

    public static void asyncSend(XxlRpcRequest xxlRpcRequest, String address, Class<? extends ConnectClient> connectClientImpl, XxlRpcReferenceBean xxlRpcReferenceBean) throws Exception {
        ConnectClient clientPool = ConnectClient.getPool(address, connectClientImpl, xxlRpcReferenceBean);
        clientPool.send(xxlRpcRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ConnectClient getPool(String address, Class<? extends ConnectClient> connectClientImpl, XxlRpcReferenceBean xxlRpcReferenceBean) throws Exception {
        ConnectClient connectClient;
        if (connectClientMap == null) {
            Class<ConnectClient> clazz = ConnectClient.class;
            // MONITORENTER : com.xxl.rpc.remoting.net.common.ConnectClient.class
            if (connectClientMap == null) {
                connectClientMap = new ConcurrentHashMap();
                xxlRpcReferenceBean.getInvokerFactory().addStopCallBack(new BaseCallback(){

                    @Override
                    public void run() throws Exception {
                        if (connectClientMap.size() > 0) {
                            for (String key : connectClientMap.keySet()) {
                                ConnectClient clientPool = (ConnectClient)connectClientMap.get(key);
                                clientPool.close();
                            }
                            connectClientMap.clear();
                        }
                    }
                });
            }
            // MONITOREXIT : clazz
        }
        if ((connectClient = connectClientMap.get(address)) != null && connectClient.isValidate()) {
            return connectClient;
        }
        Object clientLock = connectClientLockMap.get(address);
        if (clientLock == null) {
            connectClientLockMap.putIfAbsent(address, new Object());
            clientLock = connectClientLockMap.get(address);
        }
        Object object = clientLock;
        // MONITORENTER : object
        connectClient = connectClientMap.get(address);
        if (connectClient != null && connectClient.isValidate()) {
            // MONITOREXIT : object
            return connectClient;
        }
        if (connectClient != null) {
            connectClient.close();
            connectClientMap.remove(address);
        }
        ConnectClient connectClient_new = connectClientImpl.newInstance();
        try {
            connectClient_new.init(address, xxlRpcReferenceBean.getSerializer(), xxlRpcReferenceBean.getInvokerFactory());
            connectClientMap.put(address, connectClient_new);
            return connectClient_new;
        }
        catch (Exception e) {
            connectClient_new.close();
            throw e;
        }
    }

    static {
        connectClientLockMap = new ConcurrentHashMap();
    }
}

