/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.mina.server;

import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.util.ThrowableUtil;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaServerHandler
extends IoHandlerAdapter {
    private static Logger logger = LoggerFactory.getLogger(MinaServerHandler.class);
    private XxlRpcProviderFactory xxlRpcProviderFactory;
    private ThreadPoolExecutor serverHandlerPool;

    public MinaServerHandler(XxlRpcProviderFactory xxlRpcProviderFactory, ThreadPoolExecutor serverHandlerPool) {
        this.xxlRpcProviderFactory = xxlRpcProviderFactory;
        this.serverHandlerPool = serverHandlerPool;
    }

    public void messageReceived(final IoSession session, Object message) throws Exception {
        final XxlRpcRequest xxlRpcRequest = (XxlRpcRequest)message;
        try {
            this.serverHandlerPool.execute(new Runnable(){

                @Override
                public void run() {
                    XxlRpcResponse xxlRpcResponse = MinaServerHandler.this.xxlRpcProviderFactory.invokeService(xxlRpcRequest);
                    session.write((Object)xxlRpcResponse);
                }
            });
        }
        catch (Exception e) {
            XxlRpcResponse xxlRpcResponse = new XxlRpcResponse();
            xxlRpcResponse.setRequestId(xxlRpcRequest.getRequestId());
            xxlRpcResponse.setErrorMsg(ThrowableUtil.toString(e));
            session.write((Object)xxlRpcResponse);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        logger.error(">>>>>>>>>>> xxl-rpc provider mina server caught exception", cause);
        session.closeOnFlush();
    }

    public void sessionCreated(IoSession session) throws Exception {
        session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, 600);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        if (status == IdleStatus.BOTH_IDLE) {
            session.closeOnFlush();
            logger.debug(">>>>>>>>>>> xxl-rpc provider mina server close an idle session.");
        }
    }
}

