/*
 * Decompiled with CFR 0.152.
 */
package com.show.api.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShowApiLogger {
    private static final Log log = LogFactory.getLog((String)"showapi.log");
    private static boolean needEnableLogger = true;

    public static void setNeedEnableLogger(boolean needEnableLogger) {
        ShowApiLogger.needEnableLogger = needEnableLogger;
    }

    public static void logCommError(Exception e, String url, String appId, Map<String, String> params) {
        if (!needEnableLogger) {
            return;
        }
        if (params == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ShowApiLogger.appendLog(params, sb);
        ShowApiLogger.logCommError(e, url, appId, sb.toString());
    }

    public static void logCommError(Exception e, String urlStr, String appId, String bodyContent) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        String rspCode = "";
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date()));
        sb.append("_");
        sb.append(appId);
        sb.append("_");
        sb.append(urlStr);
        sb.append("_");
        sb.append(rspCode);
        sb.append("_");
        sb.append(String.valueOf(e.getMessage()).replaceAll("\r\n", " "));
        sb.append(bodyContent);
        log.error((Object)sb.toString());
    }

    private static void appendLog(Map map, StringBuilder sb) {
        boolean first = true;
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            if (!first) {
                sb.append("&");
            } else {
                first = false;
            }
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
    }
}

