/*
 * Decompiled with CFR 0.152.
 */
package com.show.api.util;

import com.show.api.FileItem;
import com.show.api.NormalRequest;
import com.show.api.util.ResData;
import com.show.api.util.ShowApiLogger;
import com.show.api.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class WebUtils {
    private static final String METHOD_LIST = "LIST";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";

    public static ResData _doGetAsByte(NormalRequest req) throws IOException {
        HttpURLConnection conn = null;
        byte[] rsp = null;
        ResData res = new ResData();
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + req.getCharset();
            String query = WebUtils.buildQuery(req.getTextMap(), req.getCharset());
            try {
                conn = WebUtils.getConnection(WebUtils.buildGetUrl(req.getUrl(), query), METHOD_GET, ctype, req);
                conn.setConnectTimeout(req.getConnectTimeout());
                conn.setReadTimeout(req.getReadTimeout());
            }
            catch (IOException e) {
                ShowApiLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("showapi_app_id"), req.getTextMap());
                throw e;
            }
            try {
                Map<String, List<String>> res_headMap = conn.getHeaderFields();
                rsp = WebUtils.getResponseAsByte(conn);
                req.setRes_headtMap(res_headMap);
            }
            catch (IOException e) {
                ShowApiLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("showapi_app_id"), req.getTextMap());
                throw e;
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        res.setResData(rsp);
        res.setRes_maybe_encoding(WebUtils.getResponseCharset(conn.getContentType()));
        return res;
    }

    public static ResData _doPostAsByte(NormalRequest req) throws IOException {
        HttpURLConnection conn;
        byte[] rsp;
        ResData res;
        block23: {
            res = new ResData();
            rsp = null;
            conn = null;
            OutputStream out = null;
            if (req.getBody() != null) {
                String ctype = "application/octet-stream;charset=" + req.getCharset();
                try {
                    try {
                        conn = WebUtils.getConnection(new URL(req.getUrl()), METHOD_POST, ctype, req);
                        conn.setConnectTimeout(req.getConnectTimeout());
                        conn.setReadTimeout(req.getReadTimeout());
                        out = conn.getOutputStream();
                        out.write(req.getBody());
                        out.flush();
                        Map<String, List<String>> res_headMap = conn.getHeaderFields();
                        rsp = WebUtils.getResponseAsByte(conn);
                        req.setRes_headtMap(res_headMap);
                        break block23;
                    }
                    catch (IOException e) {
                        ShowApiLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("showapi_app_id"), new HashMap<String, String>());
                        throw e;
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
            if (req.getBodyString() != null) {
                String ctype = "application/octet-stream;charset=" + req.getCharset();
                try {
                    try {
                        conn = WebUtils.getConnection(new URL(req.getUrl()), METHOD_POST, ctype, req);
                        conn.setConnectTimeout(req.getConnectTimeout());
                        conn.setReadTimeout(req.getReadTimeout());
                        out = conn.getOutputStream();
                        out.write(req.getBodyString().getBytes(req.getCharset()));
                        out.flush();
                        Map<String, List<String>> res_headMap = conn.getHeaderFields();
                        rsp = WebUtils.getResponseAsByte(conn);
                        req.setRes_headtMap(res_headMap);
                        break block23;
                    }
                    catch (IOException e) {
                        ShowApiLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("showapi_app_id"), new HashMap<String, String>());
                        throw e;
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
            String ctype = "application/x-www-form-urlencoded;charset=" + req.getCharset();
            String query = WebUtils.buildQuery(req.getTextMap(), req.getCharset());
            byte[] content = null;
            content = query != null ? query.getBytes(req.getCharset()) : "".getBytes(req.getCharset());
            try {
                try {
                    conn = WebUtils.getConnection(new URL(req.getUrl()), METHOD_POST, ctype, req);
                    conn.setConnectTimeout(req.getConnectTimeout());
                    conn.setReadTimeout(req.getReadTimeout());
                    out = conn.getOutputStream();
                    out.write(content);
                    Map<String, List<String>> res_headMap = conn.getHeaderFields();
                    rsp = WebUtils.getResponseAsByte(conn);
                    req.setRes_headtMap(res_headMap);
                }
                catch (IOException e) {
                    ShowApiLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("showapi_app_id"), query);
                    throw e;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        res.setResData(rsp);
        res.setRes_maybe_encoding(WebUtils.getResponseCharset(conn.getContentType()));
        return res;
    }

    private static ResData _doPostWithFileAsByte(NormalRequest req) throws IOException {
        String boundary = String.valueOf(System.nanoTime());
        HttpURLConnection conn = null;
        OutputStream out = null;
        byte[] rsp = null;
        ResData res = new ResData();
        try {
            StringBuilder strBody = new StringBuilder();
            try {
                String ctype = "multipart/form-data;charset=" + req.getCharset() + ";boundary=" + boundary;
                conn = WebUtils.getConnection(new URL(req.getUrl()), METHOD_POST, ctype, req);
                conn.setConnectTimeout(req.getConnectTimeout());
                conn.setReadTimeout(req.getReadTimeout());
                out = conn.getOutputStream();
                byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(req.getCharset());
                Set<Map.Entry<String, String>> textEntrySet = req.getTextMap().entrySet();
                for (Map.Entry<String, String> textEntry : textEntrySet) {
                    strBody.append(String.valueOf(textEntry.getKey()) + "=" + textEntry.getValue() + "&");
                    Object textBytes = WebUtils.getTextEntry(textEntry.getKey(), textEntry.getValue(), req.getCharset());
                    out.write(entryBoundaryBytes);
                    out.write((byte[])textBytes);
                }
                Set<Map.Entry<String, File>> fileEntrySet = req.getUploadMap().entrySet();
                for (Map.Entry<String, File> fileEntry : fileEntrySet) {
                    File f = fileEntry.getValue();
                    FileItem fileItem = new FileItem(f);
                    if (fileItem.getContent() == null) continue;
                    byte[] fileBytes = WebUtils.getFileEntry(fileEntry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), req.getCharset());
                    out.write(entryBoundaryBytes);
                    out.write(fileBytes);
                    out.write(fileItem.getContent());
                }
                byte[] endBoundaryBytes = ("\r\n--" + boundary + "--\r\n").getBytes(req.getCharset());
                out.write(endBoundaryBytes);
                out.flush();
                Map<String, List<String>> res_headMap = conn.getHeaderFields();
                rsp = WebUtils.getResponseAsByte(conn);
                req.setRes_headtMap(res_headMap);
            }
            catch (IOException e) {
                ShowApiLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("showapi_app_id"), strBody.toString());
                throw e;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        res.setResData(rsp);
        res.setRes_maybe_encoding(WebUtils.getResponseCharset(conn.getContentType()));
        return res;
    }

    public static String doPost(NormalRequest req) throws IOException {
        ResData res = req.getUploadMap() == null || req.getUploadMap().isEmpty() ? WebUtils._doPostAsByte(req) : WebUtils._doPostWithFileAsByte(req);
        return new String(res.getResData(), res.getRes_maybe_encoding());
    }

    public static byte[] doPostAsByte(NormalRequest req) throws IOException {
        if (req.getUploadMap() == null || req.getUploadMap().isEmpty()) {
            return WebUtils._doPostAsByte(req).getResData();
        }
        return WebUtils._doPostWithFileAsByte(req).getResData();
    }

    public static String doGet(NormalRequest req) throws IOException {
        ResData res = WebUtils._doGetAsByte(req);
        return new String(res.getResData(), res.getRes_maybe_encoding());
    }

    public static byte[] doGetAsByte(NormalRequest req) throws IOException {
        ResData res = WebUtils._doGetAsByte(req);
        return res.getResData();
    }

    public static ByteArrayOutputStream unzip(InputStream in) {
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        try {
            int num;
            GZIPInputStream gzin = new GZIPInputStream(in);
            byte[] buf = new byte[1024];
            while ((num = gzin.read(buf, 0, buf.length)) != -1) {
                fout.write(buf, 0, num);
            }
            gzin.close();
            fout.close();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return fout;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data; name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data; name=\"");
        entry.append(fieldName);
        entry.append("\"; filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, NormalRequest req) throws IOException {
        Proxy proxy = req.getProxy();
        HttpURLConnection conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection connHttps = (HttpsURLConnection)conn;
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, new TrustManager[]{new TrustAllTrustManager()}, new SecureRandom());
                connHttps.setSSLSocketFactory(ctx.getSocketFactory());
                connHttps.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            conn = connHttps;
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        if (method.equals(METHOD_POST)) {
            conn.setDoOutput(true);
        }
        conn.setRequestProperty("Accept", "application/json, text/javascript, */*; ");
        conn.setRequestProperty("User-Agent", "showapi-sdk-java");
        conn.setRequestProperty("Content-Type", ctype);
        Map<String, String> headerMap = req.getHeadMap();
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        conn.setInstanceFollowRedirects(req.isAllowRedirect());
        return conn;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty(query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty(url.getQuery()) ? (strUrl.endsWith("?") ? String.valueOf(strUrl) + query : String.valueOf(strUrl) + "?" + query) : (strUrl.endsWith("&") ? String.valueOf(strUrl) + query : String.valueOf(strUrl) + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map params, String charset) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set entries = params.entrySet();
        boolean hasParam = false;
        try {
            for (Map.Entry entry : entries) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (name == null || name.length() <= 0 || value == null) continue;
                if (hasParam) {
                    query.append("&");
                } else {
                    hasParam = true;
                }
                query.append(name).append("=").append(URLEncoder.encode(value, charset));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return query.toString();
    }

    protected static byte[] getResponseAsByte(HttpURLConnection conn) throws IOException {
        InputStream es = conn.getErrorStream();
        if (es == null) {
            if (conn.getContentEncoding() != null && conn.getContentEncoding().toLowerCase().equals("gzip")) {
                byte[] bbb = WebUtils.unzip(conn.getInputStream()).toByteArray();
                return bbb;
            }
            if (conn.getResponseCode() >= 400) {
                return new byte[0];
            }
            return WebUtils._readByteFromStream(conn.getInputStream());
        }
        String charset_res = WebUtils.getResponseCharset(conn.getContentType());
        byte[] b = WebUtils._readByteFromStream(conn.getInputStream());
        String msg = new String(b, charset_res);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(String.valueOf(conn.getResponseCode()) + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset_res = WebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            if (conn.getContentEncoding() != null && conn.getContentEncoding().toLowerCase().equals("gzip")) {
                byte[] bbb = WebUtils.unzip(conn.getInputStream()).toByteArray();
                return new String(bbb, charset_res);
            }
            return WebUtils._readCharString(conn.getInputStream(), charset_res);
        }
        String msg = WebUtils._readCharString(es, charset_res);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(String.valueOf(conn.getResponseCode()) + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    private static byte[] _readByteFromStream(InputStream stream) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int read = 0;
            while ((read = stream.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String _readCharString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = "utf-8";
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            String[] stringArray = params = ctype.split(";");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                if ((param = param.trim()).startsWith("charset")) {
                    String[] pair = param.split("=", 2);
                    if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                    charset = pair[1].trim();
                    break;
                }
                ++n2;
            }
        }
        return charset;
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static Map<String, String> getParamsFromUrl(String url) {
        Map<Object, Object> map = null;
        if (url != null && url.indexOf(63) != -1) {
            map = WebUtils.splitUrlQuery(url.substring(url.indexOf(63) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            String[] stringArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] param = pair.split("=", 2);
                if (param != null && param.length == 2) {
                    result.put(param[0], param[1]);
                }
                ++n2;
            }
        }
        return result;
    }

    public static void main(String[] adfas) throws Exception {
        byte[] b = new NormalRequest("http://localhost:80/").setCharset("utf-8").addTextPara("aaa", "bbbb").setBody("{name:'\u7ec4\u957f\u4e09'}".getBytes()).setBodyString("{name:'\u7ec4\u957f\u4e09aaa'}").postAsByte();
        String res = new String(b, "gbk");
        System.out.println(res);
    }

    public static class TrustAllTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    public static class VerisignTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

