/*
 * Decompiled with CFR 0.152.
 */
package com.show.api.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static final Log log = LogFactory.getLog(XmlUtils.class);
    private static final String XMLNS_XSI = "xmlns:xsi";
    private static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    private static final String LOGIC_YES = "yes";
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static Document newDocument() throws Exception {
        Document doc = null;
        doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        return doc;
    }

    public static Document getDocument(File file) throws Exception {
        InputStream in = XmlUtils.getInputStream(file);
        return XmlUtils.getDocument(new InputSource(in), null);
    }

    public static Document getDocument(InputSource xml, InputStream xsd) throws Exception {
        Document doc = null;
        try {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                if (xsd != null) {
                    dbf.setNamespaceAware(true);
                }
                DocumentBuilder builder = dbf.newDocumentBuilder();
                doc = builder.parse(xml);
                if (xsd != null) {
                    XmlUtils.validateXml(doc, xsd);
                }
            }
            catch (ParserConfigurationException e) {
                throw e;
            }
            catch (SAXException e) {
                throw new Exception("XML_PARSE_ERROR", e);
            }
            catch (IOException e) {
                throw new Exception("XML_READ_ERROR", e);
            }
        }
        finally {
            XmlUtils.closeStream(xml.getByteStream());
        }
        return doc;
    }

    public static Element createRootElement(String tagName) throws Exception {
        Document doc = XmlUtils.newDocument();
        Element root = doc.createElement(tagName);
        doc.appendChild(root);
        return root;
    }

    public static Element getRootElementFromStream(InputStream xml) throws Exception {
        return XmlUtils.getDocument(new InputSource(xml), null).getDocumentElement();
    }

    public static Element getRootElementFromStream(InputStream xml, InputStream xsd) throws Exception {
        return XmlUtils.getDocument(new InputSource(xml), xsd).getDocumentElement();
    }

    public static Element getRootElementFromFile(File xml) throws Exception {
        return XmlUtils.getDocument(xml).getDocumentElement();
    }

    public static Element getRootElementFromString(String payload) throws Exception {
        if (payload == null || payload.length() < 1) {
            throw new Exception("XML_PAYLOAD_EMPTY");
        }
        StringReader sr = new StringReader(XmlUtils.escapeXml(payload));
        InputSource source = new InputSource(sr);
        return XmlUtils.getDocument(source, null).getDocumentElement();
    }

    public static List<Element> getElements(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                elements.add((Element)node);
            }
            ++i;
        }
        return elements;
    }

    public static Element getElement(Element parent, String tagName) {
        List<Element> children = XmlUtils.getElements(parent, tagName);
        if (children.isEmpty()) {
            return null;
        }
        return children.get(0);
    }

    public static List<Element> getChildElements(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getParentNode() == parent) {
                elements.add((Element)node);
            }
            ++i;
        }
        return elements;
    }

    public static List<Element> getChildElements(Element parent) {
        NodeList nodes = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getParentNode() == parent) {
                elements.add((Element)node);
            }
            ++i;
        }
        return elements;
    }

    public static Element getChildElement(Element parent, String tagName) {
        List<Element> children = XmlUtils.getChildElements(parent, tagName);
        if (children.isEmpty()) {
            return null;
        }
        return children.get(0);
    }

    public static String getElementValue(Element parent, String tagName) {
        Element element = XmlUtils.getElement(parent, tagName);
        if (element != null) {
            return element.getTextContent();
        }
        return null;
    }

    public static String getChildElementValue(Element parent, String tagName) {
        Element element = XmlUtils.getChildElement(parent, tagName);
        if (element != null) {
            return element.getTextContent();
        }
        return null;
    }

    public static String getElementValue(Element element) {
        NodeList nodes;
        if (element != null && (nodes = element.getChildNodes()) != null && nodes.getLength() > 0) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof Text) {
                    return ((Text)node).getData();
                }
                ++i;
            }
        }
        return null;
    }

    public static String getAttributeValue(Element current, String attrName) {
        if (current.hasAttribute(attrName)) {
            return current.getAttribute(attrName);
        }
        return null;
    }

    public static Element appendElement(Element parent, String tagName) {
        Element child = parent.getOwnerDocument().createElement(tagName);
        parent.appendChild(child);
        return child;
    }

    public static Element appendElement(Element parent, String tagName, String value) {
        Element child = XmlUtils.appendElement(parent, tagName);
        child.setTextContent(value);
        return child;
    }

    public static void appendElement(Element parent, Element child) {
        Node tmp = parent.getOwnerDocument().importNode(child, true);
        parent.appendChild(tmp);
    }

    public static Element appendCDATAElement(Element parent, String tagName, String value) {
        Element child = XmlUtils.appendElement(parent, tagName);
        if (value == null) {
            value = "";
        }
        CDATASection cdata = child.getOwnerDocument().createCDATASection(value);
        child.appendChild(cdata);
        return child;
    }

    public static String childNodeToString(Node node) throws Exception {
        String payload = null;
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            Properties props = tf.getOutputProperties();
            props.setProperty("omit-xml-declaration", LOGIC_YES);
            props.setProperty("encoding", DEFAULT_CHARSET);
            tf.setOutputProperties(props);
            StringWriter writer = new StringWriter();
            tf.transform(new DOMSource(node), new StreamResult(writer));
            payload = XmlUtils.escapeXml(writer.toString());
        }
        catch (TransformerException e) {
            throw new Exception("XML_TRANSFORM_ERROR", e);
        }
        return payload;
    }

    public static String nodeToString(Node node) throws Exception {
        String payload = null;
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            Properties props = tf.getOutputProperties();
            props.setProperty("encoding", DEFAULT_CHARSET);
            props.setProperty("indent", LOGIC_YES);
            tf.setOutputProperties(props);
            StringWriter writer = new StringWriter();
            tf.transform(new DOMSource(node), new StreamResult(writer));
            payload = XmlUtils.escapeXml(writer.toString());
        }
        catch (TransformerException e) {
            throw new Exception("XML_TRANSFORM_ERROR", e);
        }
        return payload;
    }

    public static String escapeXml(String payload) {
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < payload.length()) {
            char c = payload.charAt(i);
            if (c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                out.append(c);
            }
            ++i;
        }
        return out.toString();
    }

    public static String xmlToString(File file) throws Exception {
        Element root = XmlUtils.getRootElementFromFile(file);
        return XmlUtils.nodeToString(root);
    }

    public static String xmlToString(InputStream in) throws Exception {
        Element root = XmlUtils.getRootElementFromStream(in);
        return XmlUtils.nodeToString(root);
    }

    public static void saveToXml(Node doc, File file) throws Exception {
        XmlUtils.saveToXml(doc, file, DEFAULT_CHARSET);
    }

    public static void saveToXml(Node doc, File file, String charset) throws Exception {
        OutputStreamWriter writer = null;
        try {
            try {
                Transformer tf = TransformerFactory.newInstance().newTransformer();
                Properties props = tf.getOutputProperties();
                props.setProperty("method", "xml");
                props.setProperty("indent", LOGIC_YES);
                tf.setOutputProperties(props);
                DOMSource dom = new DOMSource(doc);
                writer = new OutputStreamWriter(XmlUtils.getOutputStream(file), charset);
                StreamResult result = new StreamResult(writer);
                tf.transform(dom, result);
            }
            catch (Exception e) {
                throw new Exception("XML_WRITE_FILE_ERROR", e);
            }
        }
        catch (Throwable throwable) {
            XmlUtils.closeStream(writer);
            throw throwable;
        }
        XmlUtils.closeStream(writer);
    }

    public static void validateXml(InputStream xml, InputStream xsd) throws Exception {
        try {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                Document doc = dbf.newDocumentBuilder().parse(xml);
                XmlUtils.validateXml(doc, xsd);
            }
            catch (SAXException e) {
                throw new Exception("XML_VALIDATE_ERROR", e);
            }
            catch (Exception e) {
                throw new Exception("XML_READ_ERROR", e);
            }
        }
        finally {
            XmlUtils.closeStream(xml);
            XmlUtils.closeStream(xsd);
        }
    }

    public static void validateXml(Node root, InputStream xsd) throws Exception {
        try {
            try {
                StreamSource source = new StreamSource(xsd);
                Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(source);
                Validator validator = schema.newValidator();
                validator.validate(new DOMSource(root));
            }
            catch (SAXException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("\u9a8c\u8bc1XML\u6587\u4ef6\u51fa\u9519\uff1a\n" + XmlUtils.nodeToString(root)));
                }
                throw new Exception("XML_VALIDATE_ERROR", e);
            }
            catch (Exception e) {
                throw new Exception("XML_READ_ERROR", e);
            }
        }
        finally {
            XmlUtils.closeStream(xsd);
        }
    }

    public static String xmlToHtml(String payload, File xsltFile) throws Exception {
        String result = null;
        try {
            StreamSource template = new StreamSource(xsltFile);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(template);
            Properties props = transformer.getOutputProperties();
            props.setProperty("omit-xml-declaration", LOGIC_YES);
            transformer.setOutputProperties(props);
            StreamSource source = new StreamSource(new StringReader(payload));
            StreamResult sr = new StreamResult(new StringWriter());
            transformer.transform(source, sr);
            result = sr.getWriter().toString();
        }
        catch (TransformerException e) {
            throw new Exception("XML_TRANSFORM_ERROR", e);
        }
        return result;
    }

    public static void setNamespace(Element element, String namespace, String schemaLocation) {
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespace);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS_XSI, "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", XSI_SCHEMA_LOCATION, schemaLocation);
    }

    public static String encodeXml(String payload) throws Exception {
        Element root = XmlUtils.createRootElement("xml");
        root.setTextContent(payload);
        return XmlUtils.childNodeToString(root.getFirstChild());
    }

    private static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static InputStream getInputStream(File file) throws Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new Exception("XML_FILE_NOT_FOUND", e);
        }
        return in;
    }

    private static OutputStream getOutputStream(File file) throws Exception {
        FileOutputStream in = null;
        try {
            in = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new Exception("XML_FILE_NOT_FOUND", e);
        }
        return in;
    }
}

