/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.ql.util.express.DefaultContext;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.op.OperatorBase;
import com.yomahub.liteflow.builder.el.operator.AndOperator;
import com.yomahub.liteflow.builder.el.operator.AnyOperator;
import com.yomahub.liteflow.builder.el.operator.BreakOperator;
import com.yomahub.liteflow.builder.el.operator.CatchOperator;
import com.yomahub.liteflow.builder.el.operator.DataOperator;
import com.yomahub.liteflow.builder.el.operator.DefaultOperator;
import com.yomahub.liteflow.builder.el.operator.DoOperator;
import com.yomahub.liteflow.builder.el.operator.ElifOperator;
import com.yomahub.liteflow.builder.el.operator.ElseOperator;
import com.yomahub.liteflow.builder.el.operator.FinallyOperator;
import com.yomahub.liteflow.builder.el.operator.ForOperator;
import com.yomahub.liteflow.builder.el.operator.IdOperator;
import com.yomahub.liteflow.builder.el.operator.IfOperator;
import com.yomahub.liteflow.builder.el.operator.IgnoreErrorOperator;
import com.yomahub.liteflow.builder.el.operator.IteratorOperator;
import com.yomahub.liteflow.builder.el.operator.NodeOperator;
import com.yomahub.liteflow.builder.el.operator.NotOperator;
import com.yomahub.liteflow.builder.el.operator.OrOperator;
import com.yomahub.liteflow.builder.el.operator.PreOperator;
import com.yomahub.liteflow.builder.el.operator.SwitchOperator;
import com.yomahub.liteflow.builder.el.operator.TagOperator;
import com.yomahub.liteflow.builder.el.operator.ThenOperator;
import com.yomahub.liteflow.builder.el.operator.ThreadPoolOperator;
import com.yomahub.liteflow.builder.el.operator.ToOperator;
import com.yomahub.liteflow.builder.el.operator.WhenOperator;
import com.yomahub.liteflow.builder.el.operator.WhileOperator;
import com.yomahub.liteflow.exception.ELParseException;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteFlowChainELBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(LiteFlowChainELBuilder.class);
    private Chain chain = new Chain();
    private final List<Condition> conditionList = new ArrayList<Condition>();
    public static final ExpressRunner EXPRESS_RUNNER = new ExpressRunner();

    public static LiteFlowChainELBuilder createChain() {
        return new LiteFlowChainELBuilder();
    }

    public LiteFlowChainELBuilder setChainName(String chainName) {
        if (FlowBus.containChain(chainName)) {
            this.chain = FlowBus.getChain(chainName);
        } else {
            this.chain.setChainName(chainName);
        }
        return this;
    }

    public LiteFlowChainELBuilder setChainId(String chainId) {
        if (FlowBus.containChain(chainId)) {
            this.chain = FlowBus.getChain(chainId);
        } else {
            this.chain.setChainId(chainId);
        }
        return this;
    }

    public LiteFlowChainELBuilder setEL(String elStr) {
        if (StrUtil.isBlank((CharSequence)elStr)) {
            String errMsg = StrUtil.format((CharSequence)"no content in this chain[{}]", (Object[])new Object[]{this.chain.getChainId()});
            throw new FlowSystemException(errMsg);
        }
        ArrayList errorList = new ArrayList();
        try {
            DefaultContext context = new DefaultContext();
            FlowBus.getChainMap().values().forEach(chain -> context.put((Object)chain.getChainId(), chain));
            FlowBus.getNodeMap().keySet().forEach(nodeId -> context.put(nodeId, (Object)FlowBus.getNode(nodeId)));
            context.put((Object)"currChainId", (Object)this.chain.getChainId());
            Condition condition = (Condition)EXPRESS_RUNNER.execute(elStr, (IExpressContext)context, errorList, true, true);
            this.conditionList.add(condition);
            return this;
        }
        catch (QLException e) {
            if (Objects.equals(e.getCause().getMessage(), "DataNotFoundException")) {
                String msg = this.buildDataNotFoundExceptionMsg(elStr);
                throw new ELParseException(msg);
            }
            throw new ELParseException(e.getCause().getMessage());
        }
        catch (Exception e) {
            String errMsg = StrUtil.format((CharSequence)"parse el fail in this chain[{}];\r\n", (Object[])new Object[]{this.chain.getChainId()});
            throw new ELParseException(errMsg + e.getMessage());
        }
    }

    public static boolean validate(String elStr) {
        try {
            LiteFlowChainELBuilder.createChain().setEL(elStr);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return Boolean.FALSE;
        }
    }

    public void build() {
        this.chain.setConditionList(this.conditionList);
        this.checkBuild();
        FlowBus.addChain(this.chain);
    }

    private void checkBuild() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (StrUtil.isBlank((CharSequence)this.chain.getChainId())) {
            errorList.add("name is blank");
        }
        if (CollUtil.isNotEmpty(errorList)) {
            throw new RuntimeException(CollUtil.join(errorList, (CharSequence)",", (String)"[", (String)"]"));
        }
    }

    private String buildDataNotFoundExceptionMsg(String elStr) {
        String msg = String.format("[node/chain is not exist or node/chain not register]\n EL: %s", StrUtil.trim((CharSequence)elStr));
        try {
            InstructionSet parseResult = EXPRESS_RUNNER.getInstructionSetFromLocalCache(elStr);
            if (parseResult == null) {
                return msg;
            }
            Object[] outAttrNames = parseResult.getOutAttrNames();
            if (ArrayUtil.isEmpty((Object[])outAttrNames)) {
                return msg;
            }
            List chainIds = CollUtil.map(FlowBus.getChainMap().values(), Chain::getChainId, (boolean)true);
            List nodeIds = CollUtil.map(FlowBus.getNodeMap().values(), Node::getId, (boolean)true);
            for (Object attrName : outAttrNames) {
                if (chainIds.contains(attrName) || nodeIds.contains(attrName)) continue;
                msg = String.format("[%s] is not exist or [%s] is not registered, you need to define a node or chain with id [%s] and register it \n EL: ", attrName, attrName, attrName);
                String sourceEl = StrUtil.removeAll((CharSequence)elStr, (char[])new char[]{' ', '\n', '\r'});
                int commaRightIndex = sourceEl.indexOf((String)attrName + ",");
                if (commaRightIndex != -1) {
                    return msg + sourceEl + "\n" + StrUtil.fill((String)"^", (char)' ', (int)(commaRightIndex + 6), (boolean)true);
                }
                int commaLeftIndex = sourceEl.indexOf("," + (String)attrName);
                if (commaLeftIndex != -1) {
                    return msg + sourceEl + "\n" + StrUtil.fill((String)"^", (char)' ', (int)(commaLeftIndex + 7), (boolean)true);
                }
                int nodeIndex = sourceEl.indexOf(String.format("node(\"%s\")", attrName));
                if (nodeIndex == -1) continue;
                return msg + sourceEl + "\n" + StrUtil.fill((String)"^", (char)' ', (int)(commaLeftIndex + 12), (boolean)true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    static {
        EXPRESS_RUNNER.addFunction("THEN", (OperatorBase)new ThenOperator());
        EXPRESS_RUNNER.addFunction("WHEN", (OperatorBase)new WhenOperator());
        EXPRESS_RUNNER.addFunction("SWITCH", (OperatorBase)new SwitchOperator());
        EXPRESS_RUNNER.addFunction("PRE", (OperatorBase)new PreOperator());
        EXPRESS_RUNNER.addFunction("FINALLY", (OperatorBase)new FinallyOperator());
        EXPRESS_RUNNER.addFunction("IF", (OperatorBase)new IfOperator());
        EXPRESS_RUNNER.addFunction("node".toUpperCase(), (OperatorBase)new NodeOperator());
        EXPRESS_RUNNER.addFunction("node", (OperatorBase)new NodeOperator());
        EXPRESS_RUNNER.addFunction("FOR", (OperatorBase)new ForOperator());
        EXPRESS_RUNNER.addFunction("WHILE", (OperatorBase)new WhileOperator());
        EXPRESS_RUNNER.addFunction("ITERATOR", (OperatorBase)new IteratorOperator());
        EXPRESS_RUNNER.addFunction("CATCH", (OperatorBase)new CatchOperator());
        EXPRESS_RUNNER.addFunction("AND", (OperatorBase)new AndOperator());
        EXPRESS_RUNNER.addFunction("OR", (OperatorBase)new OrOperator());
        EXPRESS_RUNNER.addFunction("NOT", (OperatorBase)new NotOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("ELSE", Object.class, (OperatorBase)new ElseOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("ELIF", Object.class, (OperatorBase)new ElifOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("TO", Object.class, (OperatorBase)new ToOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("TO".toLowerCase(), Object.class, (OperatorBase)new ToOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("DEFAULT", Object.class, (OperatorBase)new DefaultOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("tag", Object.class, (OperatorBase)new TagOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("any", Object.class, (OperatorBase)new AnyOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("id", Object.class, (OperatorBase)new IdOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("ignoreError", Object.class, (OperatorBase)new IgnoreErrorOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("threadPool", Object.class, (OperatorBase)new ThreadPoolOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("DO", Object.class, (OperatorBase)new DoOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("BREAK", Object.class, (OperatorBase)new BreakOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("data", Object.class, (OperatorBase)new DataOperator());
    }
}

