/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.ExecuteTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Rollbackable;
import com.yomahub.liteflow.flow.executor.NodeExecutor;
import com.yomahub.liteflow.flow.executor.NodeExecutorHelper;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;

public class Node
implements Executable,
Cloneable,
Rollbackable {
    private static final LFLog LOG = LFLoggerManager.getLogger(Node.class);
    private String id;
    private String name;
    private String clazz;
    private NodeTypeEnum type;
    private String script;
    private String language;
    private NodeComponent instance;
    private String tag;
    private String cmpData;
    private String currChainId;
    private TransmittableThreadLocal<Integer> loopIndexTL = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Object> currLoopObject = new TransmittableThreadLocal();

    public Node() {
    }

    public Node(NodeComponent instance) {
        this.id = instance.getNodeId();
        this.name = instance.getName();
        this.instance = instance;
        this.type = instance.getType();
        this.clazz = instance.getClass().getName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeTypeEnum getType() {
        return this.type;
    }

    public void setType(NodeTypeEnum type) {
        this.type = type;
    }

    public NodeComponent getInstance() {
        return this.instance;
    }

    public void setInstance(NodeComponent instance) {
        this.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Integer slotIndex) throws Exception {
        block11: {
            if (ObjectUtil.isNull((Object)this.instance)) {
                throw new FlowSystemException("there is no instance for node id " + this.id);
            }
            Slot slot = DataBus.getSlot(slotIndex);
            try {
                this.instance.setSlotIndex(slotIndex);
                this.instance.setRefNode(this);
                LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
                if (this.instance.isAccess()) {
                    LOG.info("[O]start component[{}] execution", (Object)this.instance.getDisplayName());
                    NodeExecutor nodeExecutor = NodeExecutorHelper.loadInstance().buildNodeExecutor(this.instance.getNodeExecutorClass());
                    nodeExecutor.execute(this.instance);
                } else {
                    LOG.info("[X]skip component[{}] execution", (Object)this.instance.getDisplayName());
                }
                if (this.instance.isEnd()) {
                    String errorInfo = StrUtil.format((CharSequence)"[{}] lead the chain to end", (Object[])new Object[]{this.instance.getDisplayName()});
                    throw new ChainEndException(errorInfo);
                }
            }
            catch (ChainEndException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.instance.isContinueOnError()) {
                    String errorMsg = StrUtil.format((CharSequence)"component[{}] cause error,but flow is still go on", (Object[])new Object[]{this.id});
                    LOG.error(errorMsg);
                    break block11;
                }
                String errorMsg = StrUtil.format((CharSequence)"component[{}] cause error,error:{}", (Object[])new Object[]{this.id, e.getMessage()});
                LOG.error(errorMsg);
                throw e;
            }
            finally {
                this.instance.removeSlotIndex();
                this.instance.removeIsEnd();
                this.instance.removeRefNode();
                this.removeLoopIndex();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        try {
            this.instance.setSlotIndex(slotIndex);
            this.instance.setRefNode(this);
            this.instance.doRollback();
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format((CharSequence)"component[{}] rollback error,error:{}", (Object[])new Object[]{this.id, e.getMessage()});
            LOG.error(errorMsg);
        }
        finally {
            this.instance.removeSlotIndex();
            this.instance.removeRefNode();
        }
    }

    @Override
    public boolean isAccess(Integer slotIndex) throws Exception {
        this.instance.setSlotIndex(slotIndex);
        this.instance.setRefNode(this);
        return this.instance.isAccess();
    }

    @Override
    public ExecuteTypeEnum getExecuteType() {
        return ExecuteTypeEnum.NODE;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getCmpData() {
        return this.cmpData;
    }

    public void setCmpData(String cmpData) {
        this.cmpData = cmpData;
    }

    @Override
    public void setCurrChainId(String currentChainId) {
        this.currChainId = currentChainId;
    }

    public String getCurrChainId() {
        return this.currChainId;
    }

    public void setLoopIndex(int index) {
        this.loopIndexTL.set((Object)index);
    }

    public Integer getLoopIndex() {
        return (Integer)this.loopIndexTL.get();
    }

    public void removeLoopIndex() {
        this.loopIndexTL.remove();
    }

    public void setCurrLoopObject(Object obj) {
        this.currLoopObject.set(obj);
    }

    public <T> T getCurrLoopObject() {
        return (T)this.currLoopObject.get();
    }

    public void removeCurrLoopObject() {
        this.currLoopObject.remove();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public <T> T getItemResultMetaValue(Integer slotIndex) {
        return this.instance.getItemResultMetaValue(slotIndex);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Node copy() throws Exception {
        Node node = (Node)this.clone();
        node.loopIndexTL = new TransmittableThreadLocal();
        node.currLoopObject = new TransmittableThreadLocal();
        return node;
    }
}

