/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.NoSwitchTargetNodeException;
import com.yomahub.liteflow.exception.SwitchTargetCannotBePreOrFinallyException;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.PreCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.List;

public class SwitchCondition
extends Condition {
    private final String TAG_PREFIX = "tag";
    private final String TAG_FLAG = ":";

    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        String errorInfo;
        Node switchNode = this.getSwitchNode();
        List<Executable> targetList = this.getTargetList();
        if (!switchNode.isAccess(slotIndex)) {
            return;
        }
        switchNode.setCurrChainId(this.getCurrChainId());
        switchNode.execute(slotIndex);
        String targetId = (String)switchNode.getItemResultMetaValue(slotIndex);
        Slot slot = DataBus.getSlot(slotIndex);
        Executable targetExecutor = null;
        if (StrUtil.isNotBlank((CharSequence)targetId)) {
            if (targetId.contains(":")) {
                String[] target = targetId.split(":", 2);
                String _targetId = target[0];
                String _targetTag = target[1];
                targetExecutor = targetList.stream().filter(executable -> StrUtil.startWith((CharSequence)_targetId, (CharSequence)"tag") && ObjectUtil.equal((Object)_targetTag, (Object)executable.getTag()) || (StrUtil.isEmpty((CharSequence)_targetId) || _targetId.equals(executable.getId())) && (StrUtil.isEmpty((CharSequence)_targetTag) || _targetTag.equals(executable.getTag()))).findFirst().orElse(null);
            } else {
                targetExecutor = targetList.stream().filter(executable -> ObjectUtil.equal((Object)executable.getId(), (Object)targetId)).findFirst().orElse(null);
            }
        }
        if (ObjectUtil.isNull(targetExecutor)) {
            targetExecutor = this.getDefaultExecutor();
        }
        if (ObjectUtil.isNotNull(targetExecutor)) {
            if (targetExecutor instanceof PreCondition || targetExecutor instanceof FinallyCondition) {
                errorInfo = StrUtil.format((CharSequence)"[{}]:switch component[{}] error, switch target node cannot be pre or finally", (Object[])new Object[]{slot.getRequestId(), this.getSwitchNode().getInstance().getDisplayName()});
                throw new SwitchTargetCannotBePreOrFinallyException(errorInfo);
            }
        } else {
            errorInfo = StrUtil.format((CharSequence)"[{}]:no target node find for the component[{}],target str is [{}]", (Object[])new Object[]{slot.getRequestId(), this.getSwitchNode().getInstance().getDisplayName(), targetId});
            throw new NoSwitchTargetNodeException(errorInfo);
        }
        targetExecutor.setCurrChainId(this.getCurrChainId());
        targetExecutor.execute(slotIndex);
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_SWITCH;
    }

    public void addTargetItem(Executable executable) {
        this.addExecutable("SWITCH_TARGET_KEY", executable);
    }

    public List<Executable> getTargetList() {
        return this.getExecutableList("SWITCH_TARGET_KEY");
    }

    public void setSwitchNode(Node switchNode) {
        this.addExecutable("SWITCH_KEY", switchNode);
    }

    public Node getSwitchNode() {
        return (Node)this.getExecutableOne("SWITCH_KEY");
    }

    public Executable getDefaultExecutor() {
        return this.getExecutableOne("SWITCH_DEFAULT_KEY");
    }

    public void setDefaultExecutor(Executable defaultExecutor) {
        this.addExecutable("SWITCH_DEFAULT_KEY", defaultExecutor);
    }
}

