/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.util;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.LiteflowMethod;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.core.proxy.ComponentProxy;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ComponentProxyErrorException;
import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import java.util.Arrays;
import java.util.List;

public class LiteFlowProxyUtil {
    private static final LFLog LOG = LFLoggerManager.getLogger(LiteFlowProxyUtil.class);

    public static boolean isDeclareCmp(Class<?> clazz) {
        Class<?> targetClass = LiteFlowProxyUtil.getUserClass(clazz);
        return Arrays.stream(targetClass.getMethods()).anyMatch(method -> method.getAnnotation(LiteflowMethod.class) != null);
    }

    public static List<NodeComponent> proxy2NodeComponent(Object bean, String nodeId) {
        try {
            NodeTypeEnum nodeType = NodeTypeEnum.guessType(bean.getClass());
            ComponentProxy proxy = new ComponentProxy(nodeId, bean, nodeType.getMappingClazz());
            return proxy.getProxyList();
        }
        catch (LiteFlowException liteFlowException) {
            throw liteFlowException;
        }
        catch (Exception e) {
            String errMsg = StrUtil.format((CharSequence)"Error while proxying bean[{}]", (Object[])new Object[]{bean.getClass().getName()});
            LOG.error(errMsg);
            throw new ComponentProxyErrorException(errMsg);
        }
    }

    public static boolean isCglibProxyClass(Class<?> clazz) {
        return clazz != null && LiteFlowProxyUtil.isCglibProxyClassName(clazz.getName());
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        Class<?> superclass;
        if (clazz.getName().contains("$$") && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            return superclass;
        }
        return clazz;
    }

    private static boolean isCglibProxyClassName(String className) {
        return className != null && className.contains("$$");
    }
}

