/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.enums;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.LiteflowCmpDefine;
import com.yomahub.liteflow.annotation.LiteflowMethod;
import com.yomahub.liteflow.core.NodeBreakComponent;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.core.NodeForComponent;
import com.yomahub.liteflow.core.NodeIfComponent;
import com.yomahub.liteflow.core.NodeIteratorComponent;
import com.yomahub.liteflow.core.NodeSwitchComponent;
import com.yomahub.liteflow.core.NodeWhileComponent;
import com.yomahub.liteflow.core.ScriptBreakComponent;
import com.yomahub.liteflow.core.ScriptCommonComponent;
import com.yomahub.liteflow.core.ScriptForComponent;
import com.yomahub.liteflow.core.ScriptIfComponent;
import com.yomahub.liteflow.core.ScriptSwitchComponent;
import com.yomahub.liteflow.core.ScriptWhileComponent;
import com.yomahub.liteflow.core.proxy.LiteFlowProxyUtil;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public enum NodeTypeEnum {
    COMMON("common", "\u666e\u901a", false, NodeComponent.class),
    SWITCH("switch", "\u9009\u62e9", false, NodeSwitchComponent.class),
    IF("if", "\u6761\u4ef6", false, NodeIfComponent.class),
    FOR("for", "\u5faa\u73af\u6b21\u6570", false, NodeForComponent.class),
    WHILE("while", "\u5faa\u73af\u6761\u4ef6", false, NodeWhileComponent.class),
    BREAK("break", "\u5faa\u73af\u8df3\u51fa", false, NodeBreakComponent.class),
    ITERATOR("iterator", "\u5faa\u73af\u8fed\u4ee3", false, NodeIteratorComponent.class),
    SCRIPT("script", "\u811a\u672c", true, ScriptCommonComponent.class),
    SWITCH_SCRIPT("switch_script", "\u9009\u62e9\u811a\u672c", true, ScriptSwitchComponent.class),
    IF_SCRIPT("if_script", "\u6761\u4ef6\u811a\u672c", true, ScriptIfComponent.class),
    FOR_SCRIPT("for_script", "\u5faa\u73af\u6b21\u6570\u811a\u672c", true, ScriptForComponent.class),
    WHILE_SCRIPT("while_script", "\u5faa\u73af\u6761\u4ef6\u811a\u672c", true, ScriptWhileComponent.class),
    BREAK_SCRIPT("break_script", "\u5faa\u73af\u8df3\u51fa\u811a\u672c", true, ScriptBreakComponent.class),
    FALLBACK("fallback", "\u964d\u7ea7", false, null);

    private static final LFLog LOG;
    private String code;
    private String name;
    private boolean isScript;
    private Class<? extends NodeComponent> mappingClazz;

    private NodeTypeEnum(String code, String name, boolean isScript, Class<? extends NodeComponent> mappingClazz) {
        this.code = code;
        this.name = name;
        this.isScript = isScript;
        this.mappingClazz = mappingClazz;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isScript() {
        return this.isScript;
    }

    public void setScript(boolean script) {
        this.isScript = script;
    }

    public Class<? extends NodeComponent> getMappingClazz() {
        return this.mappingClazz;
    }

    public void setMappingClazz(Class<? extends NodeComponent> mappingClazz) {
        this.mappingClazz = mappingClazz;
    }

    public static NodeTypeEnum getEnumByCode(String code) {
        for (NodeTypeEnum e : NodeTypeEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return null;
    }

    public static NodeTypeEnum guessTypeBySuperClazz(Class<?> clazz) {
        Class<?> superClazz = clazz;
        while (!(superClazz = superClazz.getSuperclass()).getPackage().getName().startsWith("com.yomahub.liteflow.core")) {
            if (!superClazz.equals(Object.class)) continue;
            return null;
        }
        for (NodeTypeEnum e : NodeTypeEnum.values()) {
            if (e.getMappingClazz() == null || !e.getMappingClazz().equals(superClazz)) continue;
            return e;
        }
        return null;
    }

    public static NodeTypeEnum guessType(Class<?> clazz) {
        NodeTypeEnum nodeType;
        if (LiteFlowProxyUtil.isCglibProxyClass(clazz)) {
            clazz = LiteFlowProxyUtil.getUserClass(clazz);
        }
        if ((nodeType = NodeTypeEnum.guessTypeBySuperClazz(clazz)) == null) {
            LiteflowCmpDefine liteflowCmpDefine = clazz.getAnnotation(LiteflowCmpDefine.class);
            if (liteflowCmpDefine != null) {
                boolean mixDefined = Arrays.stream(clazz.getDeclaredMethods()).anyMatch(method -> {
                    LiteflowMethod liteflowMethod = (LiteflowMethod)AnnotationUtil.getAnnotation((AnnotatedElement)method, LiteflowMethod.class);
                    if (liteflowMethod != null) {
                        return StrUtil.isNotBlank((CharSequence)liteflowMethod.nodeId());
                    }
                    return false;
                });
                if (mixDefined) {
                    LOG.warn("[[[WARNING!!!]]]The @liteflowMethod in the class[{}] defined by @liteflowCmpDefine should not configure the nodeId again!", (Object)clazz.getName());
                }
                AtomicReference differenceTypeMethod = new AtomicReference();
                boolean hasDifferenceNodeType = Arrays.stream(clazz.getDeclaredMethods()).anyMatch(method -> {
                    LiteflowMethod liteflowMethod = (LiteflowMethod)AnnotationUtil.getAnnotation((AnnotatedElement)method, LiteflowMethod.class);
                    if (liteflowMethod != null) {
                        if (!liteflowMethod.nodeType().equals((Object)liteflowCmpDefine.value())) {
                            differenceTypeMethod.set(method);
                            return true;
                        }
                        return false;
                    }
                    return false;
                });
                if (hasDifferenceNodeType) {
                    LOG.warn("[[[WARNING!!!]]]The nodeType in @liteflowCmpDefine declared on the class[{}] does not match the nodeType in @liteflowMethod declared on the method[{}]!", (Object)clazz.getName(), (Object)((Method)differenceTypeMethod.get()).getName());
                }
                return liteflowCmpDefine.value();
            }
            LiteflowMethod liteflowMethod = Arrays.stream(clazz.getDeclaredMethods()).map(method -> (LiteflowMethod)AnnotationUtil.getAnnotation((AnnotatedElement)method, LiteflowMethod.class)).filter(Objects::nonNull).filter(lfMethod -> lfMethod.value().isMainMethod()).findFirst().orElse(null);
            if (liteflowMethod != null) {
                nodeType = liteflowMethod.nodeType();
            }
        }
        return nodeType;
    }

    static {
        LOG = LFLoggerManager.getLogger(NodeTypeEnum.class);
    }
}

