/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.parallel;

import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.parallel.WhenFutureObj;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import java.util.function.Supplier;

public class ParallelSupplier
implements Supplier<WhenFutureObj> {
    private static final LFLog LOG = LFLoggerManager.getLogger(ParallelSupplier.class);
    private final Executable executableItem;
    private final String currChainId;
    private final Integer slotIndex;

    public ParallelSupplier(Executable executableItem, String currChainId, Integer slotIndex) {
        this.executableItem = executableItem;
        this.currChainId = currChainId;
        this.slotIndex = slotIndex;
    }

    @Override
    public WhenFutureObj get() {
        try {
            this.executableItem.setCurrChainId(this.currChainId);
            this.executableItem.execute(this.slotIndex);
            return WhenFutureObj.success(this.executableItem.getId());
        }
        catch (Exception e) {
            return WhenFutureObj.fail(this.executableItem.getId(), e);
        }
    }
}

