/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.executor;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.flow.executor.DefaultNodeExecutor;
import com.yomahub.liteflow.flow.executor.NodeExecutor;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.util.Map;

public class NodeExecutorHelper {
    private final Map<Class<? extends NodeExecutor>, NodeExecutor> nodeExecutorMap = MapUtil.newConcurrentHashMap();

    private NodeExecutorHelper() {
    }

    public static NodeExecutorHelper loadInstance() {
        return Holder.INSTANCE;
    }

    public NodeExecutor buildNodeExecutor(Class<? extends NodeExecutor> nodeExecutorClass) {
        NodeExecutor nodeExecutor;
        if (nodeExecutorClass == null) {
            nodeExecutorClass = DefaultNodeExecutor.class;
        }
        if (ObjectUtil.isNull((Object)(nodeExecutor = this.nodeExecutorMap.get(nodeExecutorClass)))) {
            nodeExecutor = ContextAwareHolder.loadContextAware().registerBean(nodeExecutorClass);
            this.nodeExecutorMap.put(nodeExecutorClass, nodeExecutor);
        }
        return this.nodeExecutorMap.get(nodeExecutorClass);
    }

    private static class Holder {
        static final NodeExecutorHelper INSTANCE = new NodeExecutorHelper();

        private Holder() {
        }
    }
}

