/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.parallel.strategy;

import cn.hutool.core.collection.CollUtil;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.WhenCondition;
import com.yomahub.liteflow.flow.parallel.WhenFutureObj;
import com.yomahub.liteflow.flow.parallel.strategy.ParallelStrategyExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public class SpecifyParallelExecutor
extends ParallelStrategyExecutor {
    @Override
    public void execute(WhenCondition whenCondition, Integer slotIndex) throws Exception {
        CompletableFuture<Void> specifyTask;
        String currChainId = whenCondition.getCurrChainId();
        this.setWhenConditionParams(whenCondition);
        ExecutorService parallelExecutor = this.getWhenExecutorService(whenCondition);
        HashSet exitingTaskIdSet = new HashSet();
        ArrayList specifyTaskList = new ArrayList();
        ArrayList<CompletableFuture<WhenFutureObj>> allTaskList = new ArrayList<CompletableFuture<WhenFutureObj>>();
        this.filterWhenTaskList(whenCondition.getExecutableList(), slotIndex, currChainId).forEach(executable -> {
            CompletableFuture<WhenFutureObj> completableFutureTask = this.wrappedFutureObj((Executable)executable, parallelExecutor, whenCondition, currChainId, slotIndex);
            if (whenCondition.getSpecifyIdSet().contains(executable.getId())) {
                specifyTaskList.add(completableFutureTask);
                exitingTaskIdSet.add(executable.getId());
            }
            allTaskList.add(completableFutureTask);
        });
        if (CollUtil.isEmpty(specifyTaskList)) {
            this.LOG.warn("The specified task{} was not found, waiting for all tasks to complete by default.", (Object)whenCondition.getSpecifyIdSet());
            specifyTask = CompletableFuture.allOf(allTaskList.toArray(new CompletableFuture[0]));
        } else {
            Collection absentTaskIdSet = CollUtil.subtract(whenCondition.getSpecifyIdSet(), exitingTaskIdSet);
            if (CollUtil.isNotEmpty((Collection)absentTaskIdSet)) {
                this.LOG.warn("The specified task{} was not found, you need to define and register it.", (Object)absentTaskIdSet);
            }
            specifyTask = CompletableFuture.allOf(specifyTaskList.toArray(new CompletableFuture[0]));
        }
        this.handleTaskResult(whenCondition, slotIndex, allTaskList, specifyTask);
    }
}

