/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.annotation.util;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.yomahub.liteflow.annotation.AliasFor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;

public class AnnoUtil {
    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        Annotation annotation = AnnotationUtil.getAnnotation((AnnotatedElement)annotatedElement, annotationType);
        if (ObjectUtil.isNull((Object)annotation)) {
            return null;
        }
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        HashMap defaultValueMap = new HashMap();
        Arrays.stream(ReflectUtil.getMethods(annotationType)).forEach(method -> {
            AliasFor aliasFor = (AliasFor)AnnotationUtil.getAnnotation((AnnotatedElement)method, AliasFor.class);
            if (ObjectUtil.isNotNull((Object)aliasFor)) {
                aliasMap.put(method.getName(), aliasFor.value());
                defaultValueMap.put(method.getName(), AnnoUtil.getDefaultValue(annotationType, method.getName()));
            }
        });
        aliasMap.forEach((key, value1) -> {
            Object defaultValue;
            Object value = ReflectUtil.invoke((Object)annotation, (String)key, (Object[])new Object[0]);
            if (ObjectUtil.notEqual((Object)value, defaultValue = defaultValueMap.get(key))) {
                AnnotationUtil.setValue((Annotation)annotation, (String)value1, (Object)value);
            }
        });
        return (A)annotation;
    }

    public static <A extends Annotation> Object getDefaultValue(Class<A> annotationType, String property) {
        try {
            return annotationType.getMethod(property, new Class[0]).getDefaultValue();
        }
        catch (Exception e) {
            return null;
        }
    }
}

