/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.entity.executor;

import cn.hutool.core.util.ObjectUtil;
import com.google.common.collect.Maps;
import com.yomahub.liteflow.entity.executor.DefaultNodeExecutor;
import com.yomahub.liteflow.entity.executor.NodeExecutor;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.util.Map;

public class NodeExecutorHelper {
    private final Map<Class<? extends NodeExecutor>, NodeExecutor> nodeExecutorMap = Maps.newConcurrentMap();

    private NodeExecutorHelper() {
    }

    public static NodeExecutorHelper loadInstance() {
        return Holder.INSTANCE;
    }

    public NodeExecutor buildNodeExecutor(Class<? extends NodeExecutor> nodeExecutorClass) {
        NodeExecutor nodeExecutor;
        if (ObjectUtil.isNull(nodeExecutorClass)) {
            nodeExecutorClass = DefaultNodeExecutor.class;
        }
        if (ObjectUtil.isNull((Object)(nodeExecutor = this.nodeExecutorMap.get(nodeExecutorClass)))) {
            nodeExecutor = ContextAwareHolder.loadContextAware().registerBean(nodeExecutorClass);
            this.nodeExecutorMap.put(nodeExecutorClass, nodeExecutor);
        }
        return this.nodeExecutorMap.get(nodeExecutorClass);
    }

    private static class Holder {
        static final NodeExecutorHelper INSTANCE = new NodeExecutorHelper();

        private Holder() {
        }
    }
}

