/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.annotation.LiteflowRetry;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import org.springframework.core.annotation.AnnotationUtils;

public class ComponentInitializer {
    private static ComponentInitializer instance;

    public static ComponentInitializer loadInstance() {
        if (ObjectUtil.isNull((Object)instance)) {
            instance = new ComponentInitializer();
        }
        return instance;
    }

    public NodeComponent initComponent(NodeComponent nodeComponent, NodeTypeEnum type, String desc, String nodeId) {
        LiteflowRetry liteflowRetryAnnotation;
        String name;
        LiteflowComponent liteflowComponent;
        nodeComponent.setNodeId(nodeId);
        nodeComponent.setSelf(nodeComponent);
        nodeComponent.setType(type);
        nodeComponent.setName(desc);
        if (nodeComponent.getType().equals((Object)NodeTypeEnum.COMMON) && StrUtil.isBlank((CharSequence)nodeComponent.getName()) && ObjectUtil.isNotNull((Object)(liteflowComponent = nodeComponent.getClass().getAnnotation(LiteflowComponent.class))) && StrUtil.isNotBlank((CharSequence)(name = liteflowComponent.name()))) {
            nodeComponent.setName(name);
        }
        if (ObjectUtil.isNotNull((Object)(liteflowRetryAnnotation = (LiteflowRetry)AnnotationUtils.getAnnotation(nodeComponent.getClass(), LiteflowRetry.class)))) {
            nodeComponent.setRetryCount(liteflowRetryAnnotation.retry());
            nodeComponent.setRetryForExceptions(liteflowRetryAnnotation.forExceptions());
        } else {
            LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
            nodeComponent.setRetryCount(liteflowConfig.getRetryCount());
        }
        return nodeComponent;
    }
}

