/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.date.StopWatch;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.liteflow.core.NodeCondComponent;
import com.yomahub.liteflow.entity.data.CmpStep;
import com.yomahub.liteflow.entity.data.CmpStepType;
import com.yomahub.liteflow.entity.data.DataBus;
import com.yomahub.liteflow.entity.data.Slot;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.entity.monitor.CompStatistics;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.monitor.MonitorBus;
import com.yomahub.liteflow.spring.ComponentScanner;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class NodeComponent {
    private static final Logger LOG = LoggerFactory.getLogger(NodeComponent.class);
    private final TransmittableThreadLocal<Integer> slotIndexTL = new TransmittableThreadLocal();
    @Autowired(required=false)
    private MonitorBus monitorBus;
    private String nodeId;
    private String name;
    private String tag;
    private Map<String, Executable> condNodeMap;
    private NodeTypeEnum type;
    private NodeComponent self;
    private int retryCount = 0;
    private Class<? extends Exception>[] retryForExceptions = new Class[]{Exception.class};
    private final TransmittableThreadLocal<Boolean> isEndTL = new TransmittableThreadLocal();

    public void execute() throws Exception {
        Executable condExecutor;
        String condNodeId;
        Object slot = this.getSlot();
        LOG.info("[{}]:[O]start component[{}] execution", (Object)slot.getRequestId(), (Object)this.getClass().getSimpleName());
        slot.addStep(new CmpStep(this.nodeId, this.name, CmpStepType.SINGLE));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.self.beforeProcess(this.getNodeId(), (Slot)slot);
        this.self.process();
        this.self.afterProcess(this.getNodeId(), (Slot)slot);
        stopWatch.stop();
        long timeSpent = stopWatch.getTotalTimeMillis();
        if (ObjectUtil.isNotNull((Object)this.monitorBus)) {
            CompStatistics statistics = new CompStatistics(this.getClass().getSimpleName(), timeSpent);
            this.monitorBus.addStatistics(statistics);
        }
        if (this instanceof NodeCondComponent && StrUtil.isNotBlank((CharSequence)(condNodeId = (String)slot.getCondResult(this.getClass().getName()))) && ObjectUtil.isNotNull((Object)(condExecutor = this.condNodeMap.get(condNodeId)))) {
            condExecutor.execute((Integer)this.slotIndexTL.get());
        }
        LOG.debug("[{}]:componnet[{}] finished in {} milliseconds", new Object[]{slot.getRequestId(), this.getClass().getSimpleName(), timeSpent});
    }

    public abstract void process() throws Exception;

    public void beforeProcess(String nodeId, Slot slot) {
        if (ObjectUtil.isNotNull((Object)ComponentScanner.cmpAroundAspect)) {
            ComponentScanner.cmpAroundAspect.beforeProcess(nodeId, slot);
        }
    }

    public void afterProcess(String nodeId, Slot slot) {
        if (ObjectUtil.isNotNull((Object)ComponentScanner.cmpAroundAspect)) {
            ComponentScanner.cmpAroundAspect.afterProcess(nodeId, slot);
        }
    }

    public boolean isAccess() {
        return true;
    }

    public boolean isContinueOnError() {
        return false;
    }

    public boolean isEnd() {
        Boolean isEnd = (Boolean)this.isEndTL.get();
        if (ObjectUtil.isNull((Object)isEnd)) {
            return false;
        }
        return (Boolean)this.isEndTL.get();
    }

    public void setIsEnd(boolean isEnd) {
        this.isEndTL.set((Object)isEnd);
    }

    public void removeIsEnd() {
        this.isEndTL.remove();
    }

    public NodeComponent setSlotIndex(Integer slotIndex) {
        this.slotIndexTL.set((Object)slotIndex);
        return this;
    }

    public Integer getSlotIndex() {
        return (Integer)this.slotIndexTL.get();
    }

    public void removeSlotIndex() {
        this.slotIndexTL.remove();
    }

    public <T extends Slot> T getSlot() {
        return DataBus.getSlot((Integer)this.slotIndexTL.get());
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public NodeComponent getSelf() {
        return this.self;
    }

    public void setSelf(NodeComponent self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeTypeEnum getType() {
        return this.type;
    }

    public void setType(NodeTypeEnum type) {
        this.type = type;
    }

    public <T> void sendPrivateDeliveryData(String nodeId, T t) {
        this.getSlot().setPrivateDeliveryData(nodeId, t);
    }

    public <T> T getPrivateDeliveryData() {
        return this.getSlot().getPrivateDeliveryData(this.getNodeId());
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public Class<? extends Exception>[] getRetryForExceptions() {
        return this.retryForExceptions;
    }

    public void setRetryForExceptions(Class<? extends Exception>[] retryForExceptions) {
        this.retryForExceptions = retryForExceptions;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Map<String, Executable> getCondNodeMap() {
        return this.condNodeMap;
    }

    public void setCondNodeMap(Map<String, Executable> condNodeMap) {
        this.condNodeMap = condNodeMap;
    }
}

