/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.entity.flow;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.yomahub.liteflow.entity.data.DataBus;
import com.yomahub.liteflow.entity.flow.Condition;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.entity.flow.PreCondition;
import com.yomahub.liteflow.entity.flow.ThenCondition;
import com.yomahub.liteflow.entity.flow.WhenCondition;
import com.yomahub.liteflow.entity.flow.parallel.CompletableFutureTimeout;
import com.yomahub.liteflow.entity.flow.parallel.ParallelSupplier;
import com.yomahub.liteflow.entity.flow.parallel.WhenFutureObj;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.ExecuteTypeEnum;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.exception.WhenExecuteException;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.util.ExecutorHelper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chain
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(Chain.class);
    private String chainName;
    private List<Condition> conditionList;

    public Chain(String chainName, List<Condition> conditionList) {
        this.chainName = chainName;
        this.conditionList = conditionList;
    }

    public List<Condition> getConditionList() {
        return this.conditionList;
    }

    public void setConditionList(List<Condition> conditionList) {
        this.conditionList = conditionList;
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Integer slotIndex) throws Exception {
        if (CollUtil.isEmpty(this.conditionList)) {
            throw new FlowSystemException("no conditionList in this chain[" + this.chainName + "]");
        }
        Object slot = DataBus.getSlot(slotIndex);
        List finallyConditionList = this.conditionList.stream().filter(condition -> condition.getConditionType().equals(ConditionTypeEnum.TYPE_FINALLY.getType())).collect(Collectors.toList());
        try {
            for (Condition condition2 : this.conditionList) {
                if (condition2 instanceof PreCondition) {
                    for (Executable executableItem : condition2.getNodeList()) {
                        executableItem.execute(slotIndex);
                    }
                    continue;
                }
                if (condition2 instanceof ThenCondition) {
                    for (Executable executableItem : condition2.getNodeList()) {
                        executableItem.execute(slotIndex);
                    }
                    continue;
                }
                if (!(condition2 instanceof WhenCondition)) continue;
                this.executeAsyncCondition((WhenCondition)condition2, slotIndex, slot.getRequestId());
            }
        }
        catch (Throwable throwable) {
            for (Condition finallyCondition : finallyConditionList) {
                for (Executable executableItem : finallyCondition.getNodeList()) {
                    executableItem.execute(slotIndex);
                }
            }
            throw throwable;
        }
        for (Condition finallyCondition : finallyConditionList) {
            for (Executable executableItem : finallyCondition.getNodeList()) {
                executableItem.execute(slotIndex);
            }
        }
    }

    @Override
    public ExecuteTypeEnum getExecuteType() {
        return ExecuteTypeEnum.CHAIN;
    }

    @Override
    public String getExecuteName() {
        return this.chainName;
    }

    private void executeAsyncCondition(WhenCondition condition, Integer slotIndex, String requestId) throws Exception {
        ExecutorService parallelExecutor = TtlExecutors.getTtlExecutorService((ExecutorService)ExecutorHelper.loadInstance().buildExecutor());
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        boolean[] interrupted = new boolean[]{false};
        List<CompletableFuture> completableFutureList = condition.getNodeList().stream().map(executable -> CompletableFutureTimeout.completeOnTimeout(WhenFutureObj.timeOut(executable.getExecuteName()), CompletableFuture.supplyAsync(new ParallelSupplier((Executable)executable, slotIndex, requestId), parallelExecutor), liteflowConfig.getWhenMaxWaitSeconds().intValue(), TimeUnit.SECONDS)).collect(Collectors.toList());
        CompletableFuture<Object> resultCompletableFuture = condition.isAny() ? CompletableFuture.anyOf(completableFutureList.toArray(new CompletableFuture[0])) : CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0]));
        try {
            resultCompletableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("there was an error when executing the CompletableFuture", (Throwable)e);
            interrupted[0] = true;
        }
        List allCompletableWhenFutureObjList = completableFutureList.stream().filter(f -> {
            if (f.isDone()) {
                return true;
            }
            f.cancel(true);
            return false;
        }).map(f -> {
            try {
                return (WhenFutureObj)f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                interrupted[0] = true;
                return null;
            }
        }).collect(Collectors.toList());
        List<WhenFutureObj> timeOutWhenFutureObjList = allCompletableWhenFutureObjList.stream().filter(WhenFutureObj::isTimeout).collect(Collectors.toList());
        timeOutWhenFutureObjList.forEach(whenFutureObj -> LOG.warn("requestId [{}] executing thread has reached max-wait-seconds, thread canceled.Execute-item: [{}]", (Object)requestId, (Object)whenFutureObj.getExecutorName()));
        if (!condition.isErrorResume()) {
            if (interrupted[0]) {
                throw new WhenExecuteException(StrUtil.format((CharSequence)"requestId [{}] when execute interrupted. errorResume [false].", (Object[])new Object[]{requestId}));
            }
            for (WhenFutureObj whenFutureObj2 : allCompletableWhenFutureObjList) {
                if (whenFutureObj2.isSuccess()) continue;
                LOG.info(StrUtil.format((CharSequence)"requestId [{}] when-executor[{}] execute failed. errorResume [false].", (Object[])new Object[]{whenFutureObj2.getExecutorName(), requestId}));
                throw whenFutureObj2.getEx();
            }
        } else if (interrupted[0]) {
            LOG.warn("requestId [{}] executing when condition timeout , but ignore with errorResume.", (Object)requestId);
        }
    }
}

