/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.entity.flow;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.entity.data.DataBus;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.enums.ExecuteTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.FlowSystemException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node
implements Executable,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Node.class);
    private String id;
    private String name;
    private String tag;
    private NodeTypeEnum type;
    private NodeComponent instance;
    private final Map<String, Executable> condNodeMap = new HashMap<String, Executable>();

    public Node() {
    }

    public Node(NodeComponent instance) {
        this.id = instance.getNodeId();
        this.name = instance.getName();
        this.instance = instance;
        this.type = instance.getType();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeTypeEnum getType() {
        return this.type;
    }

    public void setType(NodeTypeEnum type) {
        this.type = type;
    }

    public NodeComponent getInstance() {
        return this.instance;
    }

    public void setInstance(NodeComponent instance) {
        this.instance = instance;
    }

    public Executable getCondNode(String nodeId) {
        return this.condNodeMap.get(nodeId);
    }

    public void setCondNode(String nodeId, Executable condNode) {
        this.condNodeMap.put(nodeId, condNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Integer slotIndex) throws Exception {
        block16: {
            if (ObjectUtil.isNull((Object)this.instance)) {
                throw new FlowSystemException("there is no instance for node id " + this.id);
            }
            this.instance.setSlotIndex(slotIndex);
            Object slot = DataBus.getSlot(slotIndex);
            try {
                if (this.instance.isAccess()) {
                    this.instance.setTag(this.tag);
                    this.instance.setCondNodeMap(this.condNodeMap);
                    int retryCount = this.instance.getRetryCount();
                    List<Class<? extends Exception>> forExceptions = Arrays.asList(this.instance.getRetryForExceptions());
                    for (int i = 0; i <= retryCount; ++i) {
                        try {
                            if (i > 0) {
                                LOG.info("[{}]:component[{}] performs {} retry", new Object[]{slot.getRequestId(), this.id, i + 1});
                            }
                            this.instance.execute();
                            break;
                        }
                        catch (ChainEndException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            boolean flag = forExceptions.stream().anyMatch(clazz -> clazz.isAssignableFrom(e.getClass()));
                            if (flag && i < retryCount) continue;
                            throw e;
                        }
                    }
                    if (this.instance.isEnd()) {
                        String errorInfo = StrUtil.format((CharSequence)"[{}]:component[{}] lead the chain to end", (Object[])new Object[]{slot.getRequestId(), this.instance.getClass().getSimpleName()});
                        throw new ChainEndException(errorInfo);
                    }
                } else {
                    LOG.info("[{}]:[X]skip component[{}] execution", (Object)slot.getRequestId(), (Object)this.instance.getClass().getSimpleName());
                }
            }
            catch (ChainEndException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.instance.isContinueOnError()) {
                    String errorMsg = MessageFormat.format("[{0}]:component[{1}] cause error,but flow is still go on", slot.getRequestId(), this.id);
                    LOG.error(errorMsg, (Throwable)e);
                    break block16;
                }
                String errorMsg = MessageFormat.format("[{0}]:component[{1}] cause error,error:{2}", slot.getRequestId(), this.id, e.getMessage());
                LOG.error(errorMsg, (Throwable)e);
                throw e;
            }
            finally {
                this.instance.removeSlotIndex();
                this.instance.removeIsEnd();
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Node copy() throws Exception {
        return (Node)this.clone();
    }

    @Override
    public ExecuteTypeEnum getExecuteType() {
        return ExecuteTypeEnum.NODE;
    }

    @Override
    public String getExecuteName() {
        return this.id;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

