/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.ComponentInitializer;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.core.ScriptComponent;
import com.yomahub.liteflow.core.ScriptCondComponent;
import com.yomahub.liteflow.entity.data.DataBus;
import com.yomahub.liteflow.entity.flow.Chain;
import com.yomahub.liteflow.entity.flow.Node;
import com.yomahub.liteflow.enums.FlowParserTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ComponentCannotRegisterException;
import com.yomahub.liteflow.parser.LocalJsonFlowParser;
import com.yomahub.liteflow.parser.LocalXmlFlowParser;
import com.yomahub.liteflow.parser.LocalYmlFlowParser;
import com.yomahub.liteflow.script.ScriptExecutor;
import com.yomahub.liteflow.script.ScriptExecutorFactory;
import com.yomahub.liteflow.script.exception.ScriptSpiException;
import com.yomahub.liteflow.util.CopyOnWriteHashMap;
import com.yomahub.liteflow.util.SpringAware;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowBus {
    private static final Logger LOG = LoggerFactory.getLogger(FlowBus.class);
    private static final Map<String, Chain> chainMap = new CopyOnWriteHashMap<String, Chain>();
    private static final Map<String, Node> nodeMap = new CopyOnWriteHashMap<String, Node>();

    private FlowBus() {
    }

    public static Chain getChain(String id) throws Exception {
        if (MapUtil.isEmpty(chainMap)) {
            throw new Exception("please config the rule first");
        }
        return chainMap.get(id);
    }

    public static void addChain(String name, Chain chain) {
        chainMap.put(name, chain);
    }

    public static boolean containChain(String chainId) {
        return chainMap.containsKey(chainId);
    }

    public static boolean needInit() {
        return MapUtil.isEmpty(chainMap);
    }

    public static boolean containNode(String nodeId) {
        return nodeMap.containsKey(nodeId);
    }

    public static void addSpringScanNode(String nodeId, NodeComponent nodeComponent) {
        nodeMap.put(nodeId, new Node(ComponentInitializer.loadInstance().initComponent(nodeComponent, NodeTypeEnum.COMMON, null, nodeId)));
    }

    public static void addCommonNode(String nodeId, String name, String cmpClazzStr) throws Exception {
        Class<?> cmpClazz = Class.forName(cmpClazzStr);
        FlowBus.addNode(nodeId, name, NodeTypeEnum.COMMON, cmpClazz, null);
    }

    public static void addCommonNode(String nodeId, String name, Class<? extends NodeComponent> cmpClazz) {
        FlowBus.addNode(nodeId, name, NodeTypeEnum.COMMON, cmpClazz, null);
    }

    public static void addCommonScriptNode(String nodeId, String name, String script) {
        FlowBus.addNode(nodeId, name, NodeTypeEnum.SCRIPT, ScriptComponent.class, script);
    }

    public static void addCondScriptNode(String nodeId, String name, String script) {
        FlowBus.addNode(nodeId, name, NodeTypeEnum.COND_SCRIPT, ScriptCondComponent.class, script);
    }

    private static void addNode(String nodeId, String name, NodeTypeEnum type, Class<? extends NodeComponent> cmpClazz, String script) {
        try {
            NodeComponent cmpInstance = SpringAware.registerOrGet(cmpClazz);
            if (ObjectUtil.isNull((Object)cmpInstance)) {
                LOG.warn("couldn't find component class [{}] from spring context", (Object)cmpClazz.getName());
                cmpInstance = cmpClazz.newInstance();
            }
            cmpInstance = ComponentInitializer.loadInstance().initComponent(cmpInstance, type, name, nodeId);
            if (StrUtil.isNotBlank((CharSequence)script)) {
                if (type.equals((Object)NodeTypeEnum.SCRIPT)) {
                    ((ScriptComponent)cmpInstance).loadScript(script);
                } else if (type.equals((Object)NodeTypeEnum.COND_SCRIPT)) {
                    ((ScriptCondComponent)cmpInstance).loadScript(script);
                }
            }
            nodeMap.put(nodeId, new Node(cmpInstance));
        }
        catch (Exception e) {
            String error = StrUtil.format((CharSequence)"component[{}] register error", (Object[])new Object[]{cmpClazz.getName()});
            LOG.error(error, (Throwable)e);
            throw new ComponentCannotRegisterException(error);
        }
    }

    public static Node getNode(String nodeId) {
        return nodeMap.get(nodeId);
    }

    public static Node copyNode(String nodeId) {
        try {
            Node node = nodeMap.get(nodeId);
            return node.copy();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void cleanCache() {
        chainMap.clear();
        nodeMap.clear();
        FlowBus.cleanScriptCache();
    }

    public static void cleanScriptCache() {
        try {
            ScriptExecutor scriptExecutor = ScriptExecutorFactory.loadInstance().getScriptExecutor();
            if (ObjectUtil.isNotNull((Object)scriptExecutor)) {
                scriptExecutor.cleanCache();
            }
        }
        catch (ScriptSpiException scriptSpiException) {
            // empty catch block
        }
    }

    public static void refreshFlowMetaData(FlowParserTypeEnum type, String content) throws Exception {
        if (type.equals((Object)FlowParserTypeEnum.TYPE_XML)) {
            new LocalXmlFlowParser().parse(content);
        } else if (type.equals((Object)FlowParserTypeEnum.TYPE_JSON)) {
            new LocalJsonFlowParser().parse(content);
        } else if (type.equals((Object)FlowParserTypeEnum.TYPE_YML)) {
            new LocalYmlFlowParser().parse(content);
        }
        DataBus.init();
    }
}

