/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ArrayUtil;
import com.yomahub.liteflow.entity.flow.Condition;
import com.yomahub.liteflow.entity.flow.FinallyCondition;
import com.yomahub.liteflow.entity.flow.PreCondition;
import com.yomahub.liteflow.entity.flow.ThenCondition;
import com.yomahub.liteflow.entity.flow.WhenCondition;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.ConfigErrorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public abstract class FlowParser {
    public abstract void parseMain(List<String> var1) throws Exception;

    public abstract void parse(List<String> var1) throws Exception;

    protected void buildConditions(List<Condition> conditionList, Condition condition) {
        if (condition.getConditionType().equals(ConditionTypeEnum.TYPE_PRE.getType())) {
            conditionList.add(new PreCondition(condition));
        } else if (condition.getConditionType().equals(ConditionTypeEnum.TYPE_THEN.getType())) {
            if (conditionList.size() >= 1 && CollectionUtil.getLast(conditionList) instanceof ThenCondition) {
                ((Condition)CollectionUtil.getLast(conditionList)).getNodeList().addAll(condition.getNodeList());
            } else {
                conditionList.add(new ThenCondition(condition));
            }
        } else if (condition.getConditionType().equals(ConditionTypeEnum.TYPE_WHEN.getType())) {
            if (conditionList.size() > 1 && CollectionUtil.getLast(conditionList) instanceof WhenCondition && ((Condition)CollectionUtil.getLast(conditionList)).getGroup().equals(condition.getGroup())) {
                ((Condition)CollectionUtil.getLast(conditionList)).getNodeList().addAll(condition.getNodeList());
            } else {
                conditionList.add(new WhenCondition(condition));
            }
        } else if (condition.getConditionType().equals(ConditionTypeEnum.TYPE_FINALLY.getType())) {
            conditionList.add(new FinallyCondition(condition));
        }
        CollectionUtil.sort(conditionList, (o1, o2) -> {
            if (o1.getConditionType().equals(ConditionTypeEnum.TYPE_PRE.getType()) || o2.getConditionType().equals(ConditionTypeEnum.TYPE_FINALLY.getType())) {
                return -1;
            }
            if (o2.getConditionType().equals(ConditionTypeEnum.TYPE_PRE.getType()) || o1.getConditionType().equals(ConditionTypeEnum.TYPE_FINALLY.getType())) {
                return 1;
            }
            return 0;
        });
    }

    protected Resource[] matchRuleResources(List<String> pathList) throws IOException {
        Assert.notEmpty(pathList, (String)"rule source must not be null");
        ArrayList allResource = new ArrayList();
        for (String path : pathList) {
            PathMatchingResourcePatternResolver resolver;
            Object[] resources;
            String locationPattern = path;
            if (!locationPattern.startsWith("classpath:")) {
                locationPattern = "classpath:" + locationPattern;
            }
            if (ArrayUtil.isEmpty((Object[])(resources = (resolver = new PathMatchingResourcePatternResolver()).getResources(locationPattern)))) {
                throw new ConfigErrorException("config error,please check rule source property");
            }
            allResource.addAll(ListUtil.toList((Object[])resources));
        }
        HashSet fileTypeSet = new HashSet();
        allResource.forEach(resource -> fileTypeSet.add(FileUtil.extName((String)resource.getFilename())));
        if (fileTypeSet.size() != 1) {
            throw new ConfigErrorException("config error,please use the same type of configuration");
        }
        return allResource.toArray(new Resource[0]);
    }
}

