/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.entity.flow.Chain;
import com.yomahub.liteflow.entity.flow.Condition;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.entity.flow.Node;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ExecutableItemNotFoundException;
import com.yomahub.liteflow.exception.NodeTypeNotSupportException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.FlowParser;
import com.yomahub.liteflow.parser.RegexEntity;
import com.yomahub.liteflow.parser.RegexNodeEntity;
import com.yomahub.liteflow.spring.ComponentScanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonFlowParser
extends FlowParser {
    private final Logger LOG = LoggerFactory.getLogger(JsonFlowParser.class);

    public void parse(String content) throws Exception {
        this.parse(ListUtil.toList((Object[])new String[]{content}));
    }

    @Override
    public void parse(List<String> contentList) throws Exception {
        if (CollectionUtil.isEmpty(contentList)) {
            return;
        }
        ArrayList jsonObjectList = ListUtil.toList((Object[])new JSONObject[0]);
        for (String content : contentList) {
            JSONObject flowJsonObject = JSONObject.parseObject((String)content, (Feature[])new Feature[]{Feature.OrderedField});
            jsonObjectList.add(flowJsonObject);
        }
        this.parseJsonObject(jsonObjectList);
    }

    public void parseJsonObject(List<JSONObject> flowJsonObjectList) throws Exception {
        try {
            for (Map.Entry<String, NodeComponent> componentEntry : ComponentScanner.nodeComponentMap.entrySet()) {
                if (FlowBus.containNode(componentEntry.getKey())) continue;
                FlowBus.addSpringScanNode(componentEntry.getKey(), componentEntry.getValue());
            }
            for (JSONObject flowJsonObject : flowJsonObjectList) {
                if (flowJsonObject.getJSONObject("flow").containsKey((Object)"nodes")) {
                    JSONArray nodeArrayList = flowJsonObject.getJSONObject("flow").getJSONObject("nodes").getJSONArray("node");
                    for (int i = 0; i < nodeArrayList.size(); ++i) {
                        NodeTypeEnum nodeTypeEnum;
                        JSONObject nodeObject = nodeArrayList.getJSONObject(i);
                        String id = nodeObject.getString("id");
                        String name = nodeObject.getString("name");
                        String clazz = nodeObject.getString("class");
                        String type = nodeObject.getString("type");
                        String file = nodeObject.getString("file");
                        if (StrUtil.isBlank((CharSequence)type)) {
                            type = NodeTypeEnum.COMMON.getCode();
                        }
                        if (ObjectUtil.isNull((Object)((Object)(nodeTypeEnum = NodeTypeEnum.getEnumByCode(type))))) {
                            throw new NodeTypeNotSupportException(StrUtil.format((CharSequence)"type [{}] is not support", (Object[])new Object[]{type}));
                        }
                        if (nodeTypeEnum.equals((Object)NodeTypeEnum.COMMON) && StrUtil.isNotBlank((CharSequence)clazz)) {
                            FlowBus.addCommonNode(id, name, clazz);
                            continue;
                        }
                        if (!nodeTypeEnum.equals((Object)NodeTypeEnum.SCRIPT) && !nodeTypeEnum.equals((Object)NodeTypeEnum.COND_SCRIPT)) continue;
                        String script = StrUtil.isNotBlank((CharSequence)file) ? ResourceUtil.readUtf8Str((String)StrUtil.format((CharSequence)"classpath: {}", (Object[])new Object[]{file})) : nodeObject.getString("value");
                        if (nodeTypeEnum.equals((Object)NodeTypeEnum.SCRIPT)) {
                            FlowBus.addCommonScriptNode(id, name, script);
                            continue;
                        }
                        FlowBus.addCondScriptNode(id, name, script);
                    }
                }
                JSONArray chainArray = flowJsonObject.getJSONObject("flow").getJSONArray("chain");
                for (int i = 0; i < chainArray.size(); ++i) {
                    JSONObject jsonObject = chainArray.getJSONObject(i);
                    this.parseOneChain(jsonObject, flowJsonObjectList);
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("JsonFlowParser parser exception", (Throwable)e);
            throw e;
        }
    }

    private void parseOneChain(JSONObject chainObject, List<JSONObject> flowJsonObjectList) throws Exception {
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        String chainName = chainObject.getString("name");
        JSONArray conditionArray = chainObject.getJSONArray("condition");
        for (Object o : conditionArray) {
            JSONObject condObject = (JSONObject)o;
            String condType = condObject.getString("type");
            String condArrayStr = condObject.getString("value");
            String group = condObject.getString("group");
            String errorResume = condObject.getString("errorResume");
            String any = condObject.getString("any");
            if (StrUtil.isBlank((CharSequence)condType) || StrUtil.isBlank((CharSequence)condArrayStr)) continue;
            if (StrUtil.isBlank((CharSequence)group)) {
                group = "default";
            }
            if (StrUtil.isBlank((CharSequence)errorResume)) {
                errorResume = Boolean.TRUE.toString();
            }
            if (StrUtil.isBlank((CharSequence)any)) {
                any = Boolean.FALSE.toString();
            }
            Condition condition = new Condition();
            ArrayList<Executable> chainNodeList = new ArrayList<Executable>();
            String[] condArray = condArrayStr.split(",");
            for (int i = 0; i < condArray.length; ++i) {
                String itemExpression = condArray[i].trim();
                RegexEntity regexEntity = RegexEntity.parse(itemExpression);
                RegexNodeEntity item = regexEntity.getItem();
                if (FlowBus.containNode(item.getId())) {
                    Node node = FlowBus.copyNode(item.getId());
                    node.setTag(regexEntity.getItem().getTag());
                    chainNodeList.add(node);
                    if (regexEntity.getRealItemArray() == null) continue;
                    for (RegexNodeEntity realItem : regexEntity.getRealItemArray()) {
                        if (FlowBus.containNode(realItem.getId())) {
                            Node condNode = FlowBus.copyNode(realItem.getId());
                            node.setTag(realItem.getTag());
                            node.setCondNode(condNode.getId(), condNode);
                            continue;
                        }
                        if (!this.hasChain(flowJsonObjectList, realItem.getId())) continue;
                        Chain chain = FlowBus.getChain(realItem.getId());
                        node.setCondNode(chain.getChainName(), chain);
                    }
                    continue;
                }
                if (this.hasChain(flowJsonObjectList, item.getId())) {
                    Chain chain = FlowBus.getChain(item.getId());
                    chainNodeList.add(chain);
                    continue;
                }
                String errorMsg = StrUtil.format((CharSequence)"executable node[{}] is not found!", (Object[])new Object[]{regexEntity.getItem()});
                throw new ExecutableItemNotFoundException(errorMsg);
            }
            condition.setErrorResume(errorResume.equals(Boolean.TRUE.toString()));
            condition.setGroup(group);
            condition.setAny(any.equals(Boolean.TRUE.toString()));
            condition.setConditionType(condType);
            condition.setNodeList(chainNodeList);
            super.buildConditions(conditionList, condition);
        }
        FlowBus.addChain(chainName, new Chain(chainName, conditionList));
    }

    private boolean hasChain(List<JSONObject> flowJsonObjectList, String chainName) throws Exception {
        for (JSONObject jsonObject : flowJsonObjectList) {
            JSONArray chainArray = jsonObject.getJSONObject("flow").getJSONArray("chain");
            for (int i = 0; i < chainArray.size(); ++i) {
                JSONObject chainObject = chainArray.getJSONObject(i);
                if (chainObject.getString("name").equals(chainName) && !FlowBus.containChain(chainName)) {
                    this.parseOneChain(chainObject, flowJsonObjectList);
                    return true;
                }
                if (!FlowBus.containChain(chainName)) continue;
                return true;
            }
        }
        return false;
    }
}

