/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.entity.flow.Chain;
import com.yomahub.liteflow.entity.flow.Condition;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.entity.flow.Node;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.CyclicDependencyException;
import com.yomahub.liteflow.exception.ExecutableItemNotFoundException;
import com.yomahub.liteflow.exception.NodeTypeNotSupportException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.FlowParser;
import com.yomahub.liteflow.parser.RegexEntity;
import com.yomahub.liteflow.parser.RegexNodeEntity;
import com.yomahub.liteflow.spring.ComponentScanner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlFlowParser
extends FlowParser {
    private final Logger LOG = LoggerFactory.getLogger(XmlFlowParser.class);

    public void parse(String content) throws Exception {
        this.parse(ListUtil.toList((Object[])new String[]{content}));
    }

    @Override
    public void parse(List<String> contentList) throws Exception {
        if (CollectionUtil.isEmpty(contentList)) {
            return;
        }
        ArrayList documentList = ListUtil.toList((Object[])new Document[0]);
        for (String content : contentList) {
            Document document = DocumentHelper.parseText((String)content);
            documentList.add(document);
        }
        this.parseDocument(documentList);
    }

    public void parseDocument(List<Document> documentList) throws Exception {
        for (Map.Entry<String, NodeComponent> componentEntry : ComponentScanner.nodeComponentMap.entrySet()) {
            if (FlowBus.containNode(componentEntry.getKey())) continue;
            FlowBus.addSpringScanNode(componentEntry.getKey(), componentEntry.getValue());
        }
        for (Document document : documentList) {
            Element rootElement = document.getRootElement();
            Element nodesElement = rootElement.element("nodes");
            if (ObjectUtil.isNotNull((Object)nodesElement)) {
                List nodeList = nodesElement.elements("node");
                for (Element e : nodeList) {
                    NodeTypeEnum nodeTypeEnum;
                    String id = e.attributeValue("id");
                    String name = e.attributeValue("name");
                    String clazz = e.attributeValue("class");
                    String type = e.attributeValue("type");
                    String file = e.attributeValue("file");
                    if (StrUtil.isBlank((CharSequence)type)) {
                        type = NodeTypeEnum.COMMON.getCode();
                    }
                    if (ObjectUtil.isNull((Object)((Object)(nodeTypeEnum = NodeTypeEnum.getEnumByCode(type))))) {
                        throw new NodeTypeNotSupportException(StrUtil.format((CharSequence)"type [{}] is not support", (Object[])new Object[]{type}));
                    }
                    if (nodeTypeEnum.equals((Object)NodeTypeEnum.COMMON) && StrUtil.isNotBlank((CharSequence)clazz)) {
                        FlowBus.addCommonNode(id, name, clazz);
                        continue;
                    }
                    if (!nodeTypeEnum.equals((Object)NodeTypeEnum.SCRIPT) && !nodeTypeEnum.equals((Object)NodeTypeEnum.COND_SCRIPT)) continue;
                    String script = StrUtil.isNotBlank((CharSequence)file) ? ResourceUtil.readUtf8Str((String)StrUtil.format((CharSequence)"classpath: {}", (Object[])new Object[]{file})) : e.getTextTrim();
                    if (nodeTypeEnum.equals((Object)NodeTypeEnum.SCRIPT)) {
                        FlowBus.addCommonScriptNode(id, name, script);
                        continue;
                    }
                    FlowBus.addCondScriptNode(id, name, script);
                }
            }
            List chainList = rootElement.elements("chain");
            for (Element e : chainList) {
                this.parseOneChain(e, documentList);
            }
        }
    }

    private void parseOneChain(Element e, List<Document> documentList) throws Exception {
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        String chainName = e.attributeValue("name");
        Iterator it = e.elementIterator();
        while (it.hasNext()) {
            Element condE = (Element)it.next();
            String condArrayStr = condE.attributeValue("value");
            String errorResume = condE.attributeValue("errorResume");
            String group = condE.attributeValue("group");
            String any = condE.attributeValue("any");
            if (StrUtil.isBlank((CharSequence)condArrayStr)) continue;
            if (StrUtil.isBlank((CharSequence)group)) {
                group = "default";
            }
            if (StrUtil.isBlank((CharSequence)errorResume)) {
                errorResume = Boolean.TRUE.toString();
            }
            if (StrUtil.isBlank((CharSequence)any)) {
                any = Boolean.FALSE.toString();
            }
            Condition condition = new Condition();
            ArrayList<Executable> chainNodeList = new ArrayList<Executable>();
            String[] condArray = condArrayStr.split(",");
            for (int i = 0; i < condArray.length; ++i) {
                String itemExpression = condArray[i].trim();
                RegexEntity regexEntity = RegexEntity.parse(itemExpression);
                RegexNodeEntity item = regexEntity.getItem();
                if (FlowBus.containNode(item.getId())) {
                    Node node = FlowBus.copyNode(item.getId());
                    node.setTag(regexEntity.getItem().getTag());
                    chainNodeList.add(node);
                    if (regexEntity.getRealItemArray() == null) continue;
                    for (RegexNodeEntity realItem : regexEntity.getRealItemArray()) {
                        if (FlowBus.containNode(realItem.getId())) {
                            Node condNode = FlowBus.copyNode(realItem.getId());
                            condNode.setTag(realItem.getTag());
                            node.setCondNode(condNode.getId(), condNode);
                            continue;
                        }
                        if (!this.hasChain(documentList, realItem.getId())) continue;
                        Chain chain = FlowBus.getChain(realItem.getId());
                        node.setCondNode(chain.getChainName(), chain);
                    }
                    continue;
                }
                if (this.hasChain(documentList, item.getId())) {
                    Chain chain = FlowBus.getChain(item.getId());
                    chainNodeList.add(chain);
                    continue;
                }
                String errorMsg = StrUtil.format((CharSequence)"executable node[{}] is not found!", (Object[])new Object[]{regexEntity.getItem()});
                throw new ExecutableItemNotFoundException(errorMsg);
            }
            condition.setErrorResume(errorResume.equals(Boolean.TRUE.toString()));
            condition.setGroup(group);
            condition.setAny(any.equals(Boolean.TRUE.toString()));
            condition.setConditionType(condE.getName());
            condition.setNodeList(chainNodeList);
            super.buildConditions(conditionList, condition);
        }
        FlowBus.addChain(chainName, new Chain(chainName, conditionList));
    }

    private boolean hasChain(List<Document> documentList, String chainName) throws Exception {
        try {
            for (Document document : documentList) {
                List chainList = document.getRootElement().elements("chain");
                for (Element ce : chainList) {
                    String ceName = ce.attributeValue("name");
                    if (!ceName.equals(chainName)) continue;
                    if (!FlowBus.containChain(chainName)) {
                        this.parseOneChain(ce, documentList);
                    }
                    return true;
                }
            }
            return false;
        }
        catch (StackOverflowError e) {
            this.LOG.error("a cyclic dependency occurs in chain", (Throwable)e);
            throw new CyclicDependencyException("a cyclic dependency occurs in chain");
        }
    }
}

