/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.util;

import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.util.SpringAware;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorHelper {
    private final Logger LOG = LoggerFactory.getLogger(ExecutorHelper.class);
    private static ExecutorHelper executorHelper;
    private ExecutorService executorService;

    private ExecutorHelper() {
    }

    public static ExecutorHelper loadInstance() {
        if (ObjectUtil.isNull((Object)executorHelper)) {
            executorHelper = new ExecutorHelper();
        }
        return executorHelper;
    }

    public void shutdownAwaitTermination(ExecutorService pool) {
        this.shutdownAwaitTermination(pool, 60L);
    }

    public void shutdownAwaitTermination(ExecutorService pool, long timeout) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    this.LOG.error("Pool did not terminate.");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public ThreadFactory buildExecutorFactory(String name) {
        return this.buildExecutorFactory(name, false);
    }

    public ThreadFactory buildExecutorFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){
            private final AtomicLong number = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = Executors.defaultThreadFactory().newThread(r);
                newThread.setName(name + "-" + this.number.getAndIncrement());
                newThread.setDaemon(daemon);
                return newThread;
            }
        };
    }

    public ExecutorService buildExecutor() {
        if (ObjectUtil.isNull((Object)this.executorService)) {
            LiteflowConfig liteflowConfig = SpringAware.getBean(LiteflowConfig.class);
            if (ObjectUtil.isNull((Object)liteflowConfig)) {
                liteflowConfig = new LiteflowConfig();
            }
            this.executorService = new ThreadPoolExecutor(liteflowConfig.getWhenMaxWorkers(), liteflowConfig.getWhenMaxWorkers(), 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(liteflowConfig.getWhenQueueLimit()), this.buildExecutorFactory("liteflow-when-thead", false), new ThreadPoolExecutor.AbortPolicy());
        }
        return this.executorService;
    }
}

