/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder;

import cn.hutool.core.collection.CollectionUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.condition.Condition;
import com.yomahub.liteflow.flow.condition.FinallyCondition;
import com.yomahub.liteflow.flow.condition.PreCondition;
import com.yomahub.liteflow.flow.condition.ThenCondition;
import com.yomahub.liteflow.flow.condition.WhenCondition;
import com.yomahub.liteflow.flow.element.Chain;
import java.util.ArrayList;
import java.util.List;

public class LiteFlowChainBuilder {
    private Chain chain = new Chain();
    private final List<Condition> conditionList = new ArrayList<Condition>();

    public static LiteFlowChainBuilder createChain() {
        return new LiteFlowChainBuilder();
    }

    public LiteFlowChainBuilder setChainName(String chainName) {
        if (FlowBus.containChain(chainName)) {
            this.chain = FlowBus.getChain(chainName);
        } else {
            this.chain.setChainName(chainName);
        }
        return this;
    }

    public LiteFlowChainBuilder setCondition(Condition condition) {
        this.buildConditions(condition);
        return this;
    }

    public void build() {
        this.chain.setConditionList(this.conditionList);
        FlowBus.addChain(this.chain);
    }

    private void buildConditions(Condition condition) {
        if (condition.getConditionType().equals((Object)ConditionTypeEnum.TYPE_PRE)) {
            this.conditionList.add(new PreCondition(condition));
        } else if (condition.getConditionType().equals((Object)ConditionTypeEnum.TYPE_THEN)) {
            if (this.conditionList.size() >= 1 && CollectionUtil.getLast(this.conditionList) instanceof ThenCondition) {
                ((Condition)CollectionUtil.getLast(this.conditionList)).getNodeList().addAll(condition.getNodeList());
            } else {
                this.conditionList.add(new ThenCondition(condition));
            }
        } else if (condition.getConditionType().equals((Object)ConditionTypeEnum.TYPE_WHEN)) {
            if (this.conditionList.size() > 1 && CollectionUtil.getLast(this.conditionList) instanceof WhenCondition && ((Condition)CollectionUtil.getLast(this.conditionList)).getGroup().equals(condition.getGroup())) {
                ((Condition)CollectionUtil.getLast(this.conditionList)).getNodeList().addAll(condition.getNodeList());
            } else {
                this.conditionList.add(new WhenCondition(condition));
            }
        } else if (condition.getConditionType().equals((Object)ConditionTypeEnum.TYPE_FINALLY)) {
            this.conditionList.add(new FinallyCondition(condition));
        }
        CollectionUtil.sort(this.conditionList, (o1, o2) -> {
            if (o1.getConditionType().equals((Object)ConditionTypeEnum.TYPE_PRE) || o2.getConditionType().equals((Object)ConditionTypeEnum.TYPE_FINALLY)) {
                return -1;
            }
            if (o2.getConditionType().equals((Object)ConditionTypeEnum.TYPE_PRE) || o1.getConditionType().equals((Object)ConditionTypeEnum.TYPE_FINALLY)) {
                return 1;
            }
            return 0;
        });
    }
}

