/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.NodeBuildException;
import com.yomahub.liteflow.exception.NullParamException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Node;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteFlowNodeBuilder {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final Node node = new Node();

    public static LiteFlowNodeBuilder createNode() {
        return new LiteFlowNodeBuilder();
    }

    public static LiteFlowNodeBuilder createCommonNode() {
        return new LiteFlowNodeBuilder(NodeTypeEnum.COMMON);
    }

    public static LiteFlowNodeBuilder createCommonCondNode() {
        return new LiteFlowNodeBuilder(NodeTypeEnum.COMMON);
    }

    public static LiteFlowNodeBuilder createScriptNode() {
        return new LiteFlowNodeBuilder(NodeTypeEnum.SCRIPT);
    }

    public static LiteFlowNodeBuilder createScriptCondNode() {
        return new LiteFlowNodeBuilder(NodeTypeEnum.COND_SCRIPT);
    }

    public LiteFlowNodeBuilder() {
    }

    public LiteFlowNodeBuilder(NodeTypeEnum type) {
        this.node.setType(type);
    }

    public LiteFlowNodeBuilder setId(String nodeId) {
        if (StrUtil.isBlank((CharSequence)nodeId)) {
            return this;
        }
        this.node.setId(nodeId.trim());
        return this;
    }

    public LiteFlowNodeBuilder setName(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return this;
        }
        this.node.setName(name.trim());
        return this;
    }

    public LiteFlowNodeBuilder setClazz(String clazz) {
        if (StrUtil.isBlank((CharSequence)clazz)) {
            return this;
        }
        this.node.setClazz(clazz.trim());
        return this;
    }

    public LiteFlowNodeBuilder setClazz(Class<?> clazz) {
        assert (clazz != null);
        this.setClazz(clazz.getName());
        return this;
    }

    public LiteFlowNodeBuilder setNodeComponentClazz(Class<? extends NodeComponent> nodeComponentClass) {
        assert (nodeComponentClass != null);
        this.setClazz(nodeComponentClass.getName());
        return this;
    }

    public LiteFlowNodeBuilder setType(NodeTypeEnum type) {
        this.node.setType(type);
        return this;
    }

    public LiteFlowNodeBuilder setTypeCode(String nodeTypeCode) {
        if (StringUtils.isBlank((String)nodeTypeCode)) {
            throw new NullParamException("nodeTypeCode is blank");
        }
        NodeTypeEnum nodeTypeEnum = NodeTypeEnum.getEnumByCode(nodeTypeCode);
        if (ObjectUtil.isNull((Object)((Object)nodeTypeEnum))) {
            throw new NullParamException(StrUtil.format((CharSequence)"nodeTypeCode[{}] is error", (Object[])new Object[]{nodeTypeCode}));
        }
        this.setType(nodeTypeEnum);
        return this;
    }

    public LiteFlowNodeBuilder setScript(String script) {
        this.node.setScript(script);
        return this;
    }

    public LiteFlowNodeBuilder setFile(String filePath) {
        if (StrUtil.isBlank((CharSequence)filePath)) {
            return this;
        }
        String script = ResourceUtil.readUtf8Str((String)StrUtil.format((CharSequence)"classpath: {}", (Object[])new Object[]{filePath.trim()}));
        return this.setScript(script);
    }

    public void build() {
        try {
            if (this.node.getType().equals((Object)NodeTypeEnum.COMMON)) {
                FlowBus.addCommonNode(this.node.getId(), this.node.getName(), this.node.getClazz());
            } else if (this.node.getType().equals((Object)NodeTypeEnum.SCRIPT)) {
                FlowBus.addCommonScriptNode(this.node.getId(), this.node.getName(), this.node.getScript());
            } else if (this.node.getType().equals((Object)NodeTypeEnum.COND_SCRIPT)) {
                FlowBus.addCondScriptNode(this.node.getId(), this.node.getName(), this.node.getScript());
            }
        }
        catch (Exception e) {
            String errMsg = StrUtil.format((CharSequence)"An exception occurred while building the node[{}]", (Object[])new Object[]{this.node.getId()});
            this.LOG.error(errMsg, (Throwable)e);
            throw new NodeBuildException(errMsg);
        }
    }
}

