/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.LiteflowRetry;
import com.yomahub.liteflow.annotation.util.AnnoUtil;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.executor.NodeExecutor;
import com.yomahub.liteflow.monitor.MonitorBus;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import com.yomahub.liteflow.spi.holder.LiteflowComponentSupportHolder;

public class ComponentInitializer {
    private static ComponentInitializer instance;

    public static ComponentInitializer loadInstance() {
        if (ObjectUtil.isNull((Object)instance)) {
            instance = new ComponentInitializer();
        }
        return instance;
    }

    public NodeComponent initComponent(NodeComponent nodeComponent, NodeTypeEnum type, String desc, String nodeId) {
        nodeComponent.setNodeId(nodeId);
        nodeComponent.setSelf(nodeComponent);
        nodeComponent.setType(type);
        MonitorBus monitorBus = ContextAwareHolder.loadContextAware().getBean(MonitorBus.class);
        if (ObjectUtil.isNotNull((Object)monitorBus)) {
            nodeComponent.setMonitorBus(monitorBus);
        }
        nodeComponent.setName(desc);
        if (nodeComponent.getType().equals((Object)NodeTypeEnum.COMMON) && StrUtil.isBlank((CharSequence)nodeComponent.getName())) {
            String name = LiteflowComponentSupportHolder.loadLiteflowComponentSupport().getCmpName(nodeComponent);
            nodeComponent.setName(name);
        }
        LiteflowRetry liteflowRetryAnnotation = AnnoUtil.getAnnotation(nodeComponent.getClass(), LiteflowRetry.class);
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (ObjectUtil.isNotNull((Object)liteflowRetryAnnotation)) {
            nodeComponent.setRetryCount(liteflowRetryAnnotation.retry());
            nodeComponent.setRetryForExceptions(liteflowRetryAnnotation.forExceptions());
        } else {
            nodeComponent.setRetryCount(liteflowConfig.getRetryCount());
        }
        nodeComponent.setNodeExecutorClass(this.buildNodeExecutorClass(liteflowConfig));
        return nodeComponent;
    }

    private Class<? extends NodeExecutor> buildNodeExecutorClass(LiteflowConfig liteflowConfig) {
        Class<?> nodeExecutorClass;
        try {
            nodeExecutorClass = Class.forName(liteflowConfig.getNodeExecutorClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        return nodeExecutorClass;
    }
}

