/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.date.StopWatch;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.liteflow.core.NodeCondComponent;
import com.yomahub.liteflow.enums.CmpStepTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.entity.CmpStep;
import com.yomahub.liteflow.flow.executor.DefaultNodeExecutor;
import com.yomahub.liteflow.flow.executor.NodeExecutor;
import com.yomahub.liteflow.monitor.CompStatistics;
import com.yomahub.liteflow.monitor.MonitorBus;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.spi.holder.CmpAroundAspectHolder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeComponent {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final TransmittableThreadLocal<Integer> slotIndexTL = new TransmittableThreadLocal();
    private MonitorBus monitorBus;
    private final TransmittableThreadLocal<String> tagTL = new TransmittableThreadLocal();
    private final TransmittableThreadLocal<Map<String, Executable>> condNodeMapTL = new TransmittableThreadLocal();
    private String nodeId;
    private String name;
    private NodeTypeEnum type;
    private NodeComponent self;
    private int retryCount = 0;
    private Class<? extends Exception>[] retryForExceptions = new Class[]{Exception.class};
    private Class<? extends NodeExecutor> nodeExecutorClass = DefaultNodeExecutor.class;
    private final TransmittableThreadLocal<Boolean> isEndTL = new TransmittableThreadLocal();

    public void execute() throws Exception {
        Executable condExecutor;
        String condNodeId;
        Slot slot = this.getSlot();
        CmpStep cmpStep = new CmpStep(this.nodeId, this.name, CmpStepTypeEnum.SINGLE);
        slot.addStep(cmpStep);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.self.beforeProcess(this.getNodeId(), slot);
            this.self.process();
            this.self.onSuccess();
            cmpStep.setSuccess(true);
        }
        catch (Exception e) {
            try {
                cmpStep.setSuccess(false);
                cmpStep.setException(e);
                try {
                    this.self.onError();
                }
                catch (Exception ex) {
                    String errMsg = StrUtil.format((CharSequence)"[{}]:componnet[{}] onError method happens exception", (Object[])new Object[]{slot.getRequestId(), this.getClass().getSimpleName()});
                    this.LOG.error(errMsg, (Throwable)ex);
                }
                throw e;
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                long timeSpent = stopWatch.getTotalTimeMillis();
                this.LOG.debug("[{}]:componnet[{}] finished in {} milliseconds", new Object[]{slot.getRequestId(), this.getClass().getSimpleName(), timeSpent});
                cmpStep.setTimeSpent(timeSpent);
                this.self.afterProcess(this.getNodeId(), slot);
                if (ObjectUtil.isNotNull((Object)this.monitorBus)) {
                    CompStatistics statistics = new CompStatistics(this.getClass().getSimpleName(), timeSpent);
                    this.monitorBus.addStatistics(statistics);
                }
                throw throwable;
            }
        }
        stopWatch.stop();
        long timeSpent = stopWatch.getTotalTimeMillis();
        this.LOG.debug("[{}]:componnet[{}] finished in {} milliseconds", new Object[]{slot.getRequestId(), this.getClass().getSimpleName(), timeSpent});
        cmpStep.setTimeSpent(timeSpent);
        this.self.afterProcess(this.getNodeId(), slot);
        if (ObjectUtil.isNotNull((Object)this.monitorBus)) {
            CompStatistics statistics = new CompStatistics(this.getClass().getSimpleName(), timeSpent);
            this.monitorBus.addStatistics(statistics);
        }
        if (this instanceof NodeCondComponent && StrUtil.isNotBlank((CharSequence)(condNodeId = (String)slot.getCondResult(this.getClass().getName()))) && ObjectUtil.isNotNull((Object)(condExecutor = (Executable)((Map)this.condNodeMapTL.get()).get(condNodeId)))) {
            condExecutor.execute((Integer)this.slotIndexTL.get());
        }
    }

    public <T> void beforeProcess(String nodeId, Slot<T> slot) {
        CmpAroundAspectHolder.loadCmpAroundAspect().beforeProcess(nodeId, slot);
    }

    public abstract void process() throws Exception;

    public void onSuccess() throws Exception {
    }

    public void onError() throws Exception {
    }

    public <T> void afterProcess(String nodeId, Slot<T> slot) {
        CmpAroundAspectHolder.loadCmpAroundAspect().afterProcess(nodeId, slot);
    }

    public boolean isAccess() {
        return true;
    }

    public boolean isContinueOnError() {
        return false;
    }

    public boolean isEnd() {
        Boolean isEnd = (Boolean)this.isEndTL.get();
        if (ObjectUtil.isNull((Object)isEnd)) {
            return false;
        }
        return (Boolean)this.isEndTL.get();
    }

    public void setIsEnd(boolean isEnd) {
        this.isEndTL.set((Object)isEnd);
    }

    public void removeIsEnd() {
        this.isEndTL.remove();
    }

    public NodeComponent setSlotIndex(Integer slotIndex) {
        this.slotIndexTL.set((Object)slotIndex);
        return this;
    }

    public Integer getSlotIndex() {
        return (Integer)this.slotIndexTL.get();
    }

    public void removeSlotIndex() {
        this.slotIndexTL.remove();
    }

    public <T> Slot<T> getSlot() {
        return DataBus.getSlot((Integer)this.slotIndexTL.get());
    }

    public <T> T getContextBean() {
        Slot<T> slot = this.getSlot();
        return slot.getContextBean();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public NodeComponent getSelf() {
        return this.self;
    }

    public void setSelf(NodeComponent self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeTypeEnum getType() {
        return this.type;
    }

    public void setType(NodeTypeEnum type) {
        this.type = type;
    }

    public <T> void sendPrivateDeliveryData(String nodeId, T t) {
        this.getSlot().setPrivateDeliveryData(nodeId, t);
    }

    public <T> T getPrivateDeliveryData() {
        return this.getSlot().getPrivateDeliveryData(this.getNodeId());
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public Class<? extends Exception>[] getRetryForExceptions() {
        return this.retryForExceptions;
    }

    public void setRetryForExceptions(Class<? extends Exception>[] retryForExceptions) {
        this.retryForExceptions = retryForExceptions;
    }

    public Class<? extends NodeExecutor> getNodeExecutorClass() {
        return this.nodeExecutorClass;
    }

    public void setNodeExecutorClass(Class<? extends NodeExecutor> nodeExecutorClass) {
        this.nodeExecutorClass = nodeExecutorClass;
    }

    public void setTag(String tag) {
        this.tagTL.set((Object)tag);
    }

    public String getTag() {
        return (String)this.tagTL.get();
    }

    public void setCondNodeMap(Map<String, Executable> condNodeMap) {
        this.condNodeMapTL.set(condNodeMap);
    }

    public MonitorBus getMonitorBus() {
        return this.monitorBus;
    }

    public void setMonitorBus(MonitorBus monitorBus) {
        this.monitorBus = monitorBus;
    }

    public <T> T getRequestData() {
        return this.getSlot().getRequestData();
    }

    public <T> T getSubChainReqData() {
        return this.getSlot().getChainReqData(this.getChainName());
    }

    public String getChainName() {
        return this.getSlot().getChainName();
    }
}

