/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core.proxy;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.LiteflowMethod;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.core.proxy.LiteFlowMethodBean;
import com.yomahub.liteflow.exception.ComponentMethodDefineErrorException;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;
import com.yomahub.liteflow.util.SerialsUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentProxy {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final String nodeId;
    private final Object bean;
    private final Class<?> clazz;

    public ComponentProxy(String nodeId, Object bean, Class<?> clazz) {
        this.nodeId = nodeId;
        this.bean = bean;
        this.clazz = clazz;
    }

    public Object getProxy() throws Exception {
        Class<?> beanClazz = LiteFlowProxyUtil.isCglibProxyClass(this.bean.getClass()) ? LiteFlowProxyUtil.getUserClass(this.bean.getClass()) : this.bean.getClass();
        List<String> methodStrList = Arrays.stream(beanClazz.getDeclaredMethods()).filter(m -> m.getAnnotation(LiteflowMethod.class) != null).map(m -> {
            LiteflowMethod liteflowMethod = m.getAnnotation(LiteflowMethod.class);
            return liteflowMethod.value().getMethodName();
        }).collect(Collectors.toList());
        return new ByteBuddy().subclass(this.clazz).name(StrUtil.format((CharSequence)"{}.ByteBuddy${}${}", (Object[])new Object[]{ClassUtil.getPackage(this.bean.getClass()), this.nodeId, SerialsUtil.generateShortUUID()})).method((ElementMatcher)ElementMatchers.namedOneOf((String[])methodStrList.toArray(new String[0]))).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new AopInvocationHandler(this.bean))).annotateType(this.bean.getClass().getAnnotations()).make().load(ComponentProxy.class.getClassLoader()).getLoaded().newInstance();
    }

    public class AopInvocationHandler
    implements InvocationHandler {
        private final Object bean;

        public AopInvocationHandler(Object bean) {
            this.bean = bean;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            List liteFlowMethodBeanList = Arrays.stream(ReflectUtil.getMethods(this.bean.getClass())).filter(m -> {
                LiteflowMethod liteFlowMethod = m.getAnnotation(LiteflowMethod.class);
                return ObjectUtil.isNotNull((Object)liteFlowMethod);
            }).map(m -> {
                LiteflowMethod liteFlowMethod = m.getAnnotation(LiteflowMethod.class);
                return new LiteFlowMethodBean(liteFlowMethod.value().getMethodName(), (Method)m);
            }).collect(Collectors.toList());
            LiteFlowMethodBean liteFlowMethodBean = liteFlowMethodBeanList.stream().filter(liteFlowMethodBean1 -> liteFlowMethodBean1.getMethodName().equals(method.getName())).findFirst().orElse(null);
            if (!ListUtil.toList((Object[])new String[]{"beforeProcess", "afterProcess"}).contains(liteFlowMethodBean.getMethodName())) {
                boolean checkFlag;
                boolean bl = checkFlag = liteFlowMethodBean.getMethod().getParameterTypes().length == 1 && Arrays.asList(liteFlowMethodBean.getMethod().getParameterTypes()).contains(NodeComponent.class);
                if (!checkFlag) {
                    String errMsg = StrUtil.format((CharSequence)"Method[{}.{}] must have NodeComponent parameter(and only one parameter)", (Object[])new Object[]{this.bean.getClass().getName(), liteFlowMethodBean.getMethod().getName()});
                    ComponentProxy.this.LOG.error(errMsg);
                    throw new ComponentMethodDefineErrorException(errMsg);
                }
                try {
                    return liteFlowMethodBean.getMethod().invoke(this.bean, proxy);
                }
                catch (Exception e) {
                    InvocationTargetException targetEx = (InvocationTargetException)e;
                    throw targetEx.getTargetException();
                }
            }
            try {
                return liteFlowMethodBean.getMethod().invoke(this.bean, args);
            }
            catch (Exception e) {
                InvocationTargetException targetEx = (InvocationTargetException)e;
                throw targetEx.getTargetException();
            }
        }
    }
}

