/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.executor;

import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeExecutor {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public void execute(NodeComponent instance) throws Exception {
        int retryCount = instance.getRetryCount();
        List<Class<? extends Exception>> forExceptions = Arrays.asList(instance.getRetryForExceptions());
        for (int i = 0; i <= retryCount; ++i) {
            try {
                if (i == 0) {
                    instance.execute();
                    break;
                }
                this.retry(instance, i);
                break;
            }
            catch (ChainEndException e) {
                throw e;
            }
            catch (Exception e) {
                boolean flag = forExceptions.stream().anyMatch(clazz -> clazz.isAssignableFrom(e.getClass()));
                if (flag && i < retryCount) continue;
                throw e;
            }
        }
    }

    protected void retry(NodeComponent instance, int currentRetryCount) throws Exception {
        Slot slot = DataBus.getSlot(instance.getSlotIndex());
        this.LOG.info("[{}]:component[{}] performs {} retry", new Object[]{slot.getRequestId(), instance.getNodeId(), currentRetryCount + 1});
        instance.execute();
    }
}

