/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.slot;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.slot.Slot;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBus {
    private static final Logger LOG = LoggerFactory.getLogger(DataBus.class);
    public static AtomicInteger OCCUPY_COUNT = new AtomicInteger(0);
    private static ConcurrentHashMap<Integer, Slot<?>> SLOTS;
    private static ConcurrentLinkedQueue<Integer> QUEUE;
    private static Integer currentIndexMaxValue;

    public static void init() {
        if (MapUtil.isEmpty(SLOTS)) {
            LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
            currentIndexMaxValue = liteflowConfig.getSlotSize();
            SLOTS = new ConcurrentHashMap();
            QUEUE = IntStream.range(0, currentIndexMaxValue).boxed().collect(Collectors.toCollection(ConcurrentLinkedQueue::new));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T> int offerSlot(Class<T> contextClazz) {
        try {
            Object contextBean = ReflectUtil.newInstanceIfPossible(contextClazz);
            Slot<Object> slot = new Slot<Object>(contextBean);
            Integer slotIndex = QUEUE.poll();
            if (ObjectUtil.isNull((Object)slotIndex)) {
                Class<DataBus> clazz = DataBus.class;
                // MONITORENTER : com.yomahub.liteflow.slot.DataBus.class
                slotIndex = QUEUE.poll();
                if (ObjectUtil.isNull((Object)slotIndex)) {
                    int nextMaxIndex = (int)Math.round((double)currentIndexMaxValue.intValue() * 1.75);
                    QUEUE.addAll(IntStream.range(currentIndexMaxValue, nextMaxIndex).boxed().collect(Collectors.toCollection(ConcurrentLinkedQueue::new)));
                    currentIndexMaxValue = nextMaxIndex;
                    slotIndex = QUEUE.poll();
                }
                // MONITOREXIT : clazz
            }
            if (!ObjectUtil.isNotNull((Object)slotIndex)) return -1;
            SLOTS.put(slotIndex, slot);
            OCCUPY_COUNT.incrementAndGet();
            return slotIndex;
        }
        catch (Exception e) {
            LOG.error("offer slot error", (Throwable)e);
            return -1;
        }
    }

    public static <T> Slot<T> getSlot(int slotIndex) {
        return SLOTS.get(slotIndex);
    }

    public static <T> T getContextBean(int slotIndex) {
        Slot<T> slot = DataBus.getSlot(slotIndex);
        return slot.getContextBean();
    }

    public static void releaseSlot(int slotIndex) {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (ObjectUtil.isNotNull(SLOTS.get(slotIndex))) {
            if (BooleanUtil.isTrue((Boolean)liteflowConfig.getPrintExecutionLog())) {
                LOG.info("[{}]:slot[{}] released", (Object)SLOTS.get(slotIndex).getRequestId(), (Object)slotIndex);
            }
            SLOTS.remove(slotIndex);
            QUEUE.add(slotIndex);
            OCCUPY_COUNT.decrementAndGet();
        } else {
            LOG.warn("slot[{}] already has been released", (Object)slotIndex);
        }
    }
}

